<?php
session_start();
require_once '../config/database.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Non autorisé']);
    exit();
}

$database = new Database();
$db = $database->getConnection();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $performance_id = (int)$input['performance_id'];
    $action = $input['action'];
    
    if ($action === 'toggle') {
        // Vérifier si déjà en favoris
        $check_query = "SELECT 1 FROM favorites WHERE user_id = :user_id AND performance_id = :performance_id";
        $check_stmt = $db->prepare($check_query);
        $check_stmt->bindParam(':user_id', $_SESSION['user_id']);
        $check_stmt->bindParam(':performance_id', $performance_id);
        $check_stmt->execute();
        
        if ($check_stmt->rowCount() > 0) {
            // Retirer des favoris
            $delete_query = "DELETE FROM favorites WHERE user_id = :user_id AND performance_id = :performance_id";
            $delete_stmt = $db->prepare($delete_query);
            $delete_stmt->bindParam(':user_id', $_SESSION['user_id']);
            $delete_stmt->bindParam(':performance_id', $performance_id);
            $delete_stmt->execute();
            
            echo json_encode(['success' => true, 'is_favorite' => false]);
        } else {
            // Ajouter aux favoris
            $insert_query = "INSERT INTO favorites (user_id, performance_id) VALUES (:user_id, :performance_id)";
            $insert_stmt = $db->prepare($insert_query);
            $insert_stmt->bindParam(':user_id', $_SESSION['user_id']);
            $insert_stmt->bindParam(':performance_id', $performance_id);
            $insert_stmt->execute();
            
            echo json_encode(['success' => true, 'is_favorite' => true]);
        }
    }
} else {
    // GET - Récupérer les favoris
    $query = "SELECT p.*, c.name as category_name, AVG(r.rating) as avg_rating, COUNT(r.id) as review_count
              FROM favorites f
              JOIN performances p ON f.performance_id = p.id
              LEFT JOIN categories c ON p.category_id = c.id
              LEFT JOIN reviews r ON p.id = r.performance_id AND r.is_approved = 1
              WHERE f.user_id = :user_id
              GROUP BY p.id
              ORDER BY f.created_at DESC";
    
    $stmt = $db->prepare($query);
    $stmt->bindParam(':user_id', $_SESSION['user_id']);
    $stmt->execute();
    
    $favorites = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($favorites);
}
?>
