// JavaScript pour la page des groupes

document.addEventListener("DOMContentLoaded", () => {
  initGroups()
  initSearch()
  initModals()
})

function initGroups() {
  console.log("Page groupes initialisée")

  // Animer les cartes
  animateGroupCards()

  // Initialiser les interactions
  initGroupInteractions()
}

function animateGroupCards() {
  const cards = document.querySelectorAll(".group-card, .suggestion-card")

  cards.forEach((card, index) => {
    card.style.opacity = "0"
    card.style.transform = "translateY(20px)"

    setTimeout(() => {
      card.style.transition = "all 0.6s ease"
      card.style.opacity = "1"
      card.style.transform = "translateY(0)"
    }, index * 100)
  })
}

function initGroupInteractions() {
  const groupCards = document.querySelectorAll(".group-card, .suggestion-card")

  groupCards.forEach((card) => {
    card.addEventListener("mouseenter", function () {
      this.style.transform = "translateY(-5px) scale(1.02)"
      this.style.boxShadow = "0 8px 20px rgba(0,0,0,0.12)"
    })

    card.addEventListener("mouseleave", function () {
      this.style.transform = "translateY(0) scale(1)"
      this.style.boxShadow = ""
    })
  })
}

function initSearch() {
  const searchInput = document.getElementById("searchInput")

  if (searchInput) {
    searchInput.addEventListener("input", function () {
      const query = this.value.toLowerCase()
      searchGroups(query)
    })
  }
}

function searchGroups(query) {
  const cards = document.querySelectorAll(".group-card, .suggestion-card")

  cards.forEach((card) => {
    const name = card.querySelector("h4").textContent.toLowerCase()
    const description = card.querySelector(".group-description, .suggestion-description").textContent.toLowerCase()

    if (name.includes(query) || description.includes(query)) {
      card.style.display = "block"
    } else {
      card.style.display = "none"
    }
  })
}

function initModals() {
  // Modal de création de groupe
  const createModal = document.getElementById("createGroupModal")

  if (createModal) {
    // Fermer la modal en cliquant à l'extérieur
    createModal.addEventListener("click", function (e) {
      if (e.target === this) {
        closeCreateGroupModal()
      }
    })
  }
}

function openCreateGroupModal() {
  const modal = document.getElementById("createGroupModal")
  if (modal) {
    modal.style.display = "flex"
    modal.style.opacity = "0"

    setTimeout(() => {
      modal.style.transition = "opacity 0.3s ease"
      modal.style.opacity = "1"
    }, 10)

    // Focus sur le premier champ
    const firstInput = modal.querySelector("input")
    if (firstInput) {
      setTimeout(() => firstInput.focus(), 100)
    }
  }
}

function closeCreateGroupModal() {
  const modal = document.getElementById("createGroupModal")
  if (modal) {
    modal.style.opacity = "0"

    setTimeout(() => {
      modal.style.display = "none"

      // Réinitialiser le formulaire
      const form = modal.querySelector("form")
      if (form) {
        form.reset()
      }
    }, 300)
  }
}

function viewGroup(groupId) {
  // Ouvrir la page détaillée du groupe
  showGroupDetailModal(groupId)
}

function showGroupDetailModal(groupId) {
  const modal = document.createElement("div")
  modal.className = "modal group-detail-modal"
  modal.innerHTML = `
    <div class="modal-content">
      <div class="modal-header">
        <h3>Détails du groupe</h3>
        <button class="modal-close" onclick="closeGroupDetailModal()">&times;</button>
      </div>
      <div class="modal-body">
        <div class="loading">Chargement des détails...</div>
      </div>
    </div>
  `

  document.body.appendChild(modal)
  modal.style.display = "flex"

  // Charger les détails du groupe
  loadGroupDetails(groupId, modal)
}

function loadGroupDetails(groupId, modal) {
  // Simuler le chargement des données
  setTimeout(() => {
    const modalBody = modal.querySelector(".modal-body")
    modalBody.innerHTML = `
      <div class="group-detail">
        <div class="group-header">
          <h4>Nom du groupe</h4>
          <span class="member-count">12 membres</span>
        </div>
        
        <div class="group-description">
          <p>Description complète du groupe et de ses activités...</p>
        </div>
        
        <div class="group-members">
          <h5>Membres récents</h5>
          <div class="members-list">
            <div class="member-item">
              <img src="assets/images/avatar-placeholder.jpg" alt="Membre">
              <span>Nom du membre</span>
            </div>
          </div>
        </div>
        
        <div class="group-activities">
          <h5>Activités récentes</h5>
          <div class="activities-list">
            <div class="activity-item">
              <p>Nouvelle activité dans le groupe...</p>
              <small>Il y a 2 heures</small>
            </div>
          </div>
        </div>
        
        <div class="group-actions">
          <button class="btn btn-primary" onclick="planGroupEvent(${groupId})">
            Organiser une sortie
          </button>
          <button class="btn btn-outline" onclick="inviteToGroup(${groupId})">
            Inviter des amis
          </button>
        </div>
      </div>
    `
  }, 1000)
}

function closeGroupDetailModal() {
  const modal = document.querySelector(".group-detail-modal")
  if (modal) {
    modal.style.opacity = "0"
    setTimeout(() => modal.remove(), 300)
  }
}

function planGroupEvent(groupId) {
  showNotification("Fonctionnalité en cours de développement", "info")
}

function inviteToGroup(groupId) {
  showNotification("Invitation envoyée aux amis", "success")
}

function showNotification(message, type) {
  const notification = document.createElement("div")
  notification.className = `notification ${type}`
  notification.textContent = message

  document.body.appendChild(notification)

  setTimeout(() => {
    notification.classList.add("show")
  }, 100)

  setTimeout(() => {
    notification.classList.remove("show")
    setTimeout(() => notification.remove(), 300)
  }, 3000)
}

// Validation du formulaire de création
function validateCreateGroupForm() {
  const form = document.querySelector("#createGroupModal form")
  const nameInput = form.querySelector("#group_name")

  if (!nameInput.value.trim()) {
    showNotification("Le nom du groupe est requis", "error")
    nameInput.focus()
    return false
  }

  if (nameInput.value.trim().length < 3) {
    showNotification("Le nom du groupe doit contenir au moins 3 caractères", "error")
    nameInput.focus()
    return false
  }

  return true
}

// Ajouter la validation au formulaire
document.addEventListener("DOMContentLoaded", () => {
  const createForm = document.querySelector("#createGroupModal form")
  if (createForm) {
    createForm.addEventListener("submit", (e) => {
      if (!validateCreateGroupForm()) {
        e.preventDefault()
      }
    })
  }
})

// Styles CSS supplémentaires pour les modals
const additionalStyles = `
  .modal {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 1000;
    opacity: 0;
    transition: opacity 0.3s ease;
  }
  
  .modal-content {
    background: white;
    border-radius: 12px;
    max-width: 600px;
    width: 90%;
    max-height: 80vh;
    overflow-y: auto;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
  }
  
  .modal-header {
    padding: 1.5rem;
    border-bottom: 1px solid #eee;
    display: flex;
    justify-content: space-between;
    align-items: center;
  }
  
  .modal-header h3 {
    margin: 0;
    color: #333;
  }
  
  .modal-close {
    background: none;
    border: none;
    font-size: 1.5rem;
    cursor: pointer;
    color: #666;
    padding: 0;
    width: 30px;
    height: 30px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    transition: background-color 0.2s ease;
  }
  
  .modal-close:hover {
    background-color: #f0f0f0;
  }
  
  .modal-body {
    padding: 1.5rem;
  }
  
  .modal-form .form-group {
    margin-bottom: 1.5rem;
  }
  
  .modal-form label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 600;
    color: #333;
  }
  
  .modal-form input,
  .modal-form textarea {
    width: 100%;
    padding: 0.75rem;
    border: 1px solid #ddd;
    border-radius: 8px;
    font-size: 1rem;
    transition: border-color 0.2s ease;
  }
  
  .modal-form input:focus,
  .modal-form textarea:focus {
    outline: none;
    border-color: #e30b17;
    box-shadow: 0 0 0 3px rgba(227, 11, 23, 0.1);
  }
  
  .modal-actions {
    display: flex;
    gap: 1rem;
    justify-content: flex-end;
    margin-top: 2rem;
    padding-top: 1rem;
    border-top: 1px solid #eee;
  }
  
  .loading {
    text-align: center;
    padding: 2rem;
    color: #666;
  }
  
  .notification {
    position: fixed;
    top: 20px;
    right: 20px;
    padding: 1rem 1.5rem;
    border-radius: 8px;
    color: white;
    font-weight: 600;
    z-index: 1001;
    transform: translateX(100%);
    transition: transform 0.3s ease;
  }
  
  .notification.show {
    transform: translateX(0);
  }
  
  .notification.success {
    background-color: #10b981;
  }
  
  .notification.error {
    background-color: #ef4444;
  }
  
  .notification.info {
    background-color: #3b82f6;
  }
`

// Ajouter les styles
const styleSheet = document.createElement("style")
styleSheet.textContent = additionalStyles
document.head.appendChild(styleSheet)
