// JavaScript principal pour l'application Nouvel Acte

document.addEventListener("DOMContentLoaded", () => {
  // Initialisation
  console.log("Nouvel Acte - Application chargée")

  // Gestion des animations au scroll
  initScrollAnimations()

  // Gestion des formulaires
  initForms()
})

function initScrollAnimations() {
  const observerOptions = {
    threshold: 0.1,
    rootMargin: "0px 0px -50px 0px",
  }

  const observer = new IntersectionObserver((entries) => {
    entries.forEach((entry) => {
      if (entry.isIntersecting) {
        entry.target.style.opacity = "1"
        entry.target.style.transform = "translateY(0)"
      }
    })
  }, observerOptions)

  // Observer les éléments avec animation
  document.querySelectorAll(".card-item, .genre, .featured").forEach((el) => {
    el.style.opacity = "0"
    el.style.transform = "translateY(20px)"
    el.style.transition = "opacity 0.6s ease, transform 0.6s ease"
    observer.observe(el)
  })
}

function initForms() {
  // Validation des formulaires
  const forms = document.querySelectorAll("form")
  forms.forEach((form) => {
    form.addEventListener("submit", function (e) {
      if (!validateForm(this)) {
        e.preventDefault()
      }
    })
  })
}

function validateForm(form) {
  const inputs = form.querySelectorAll("input[required], textarea[required]")
  let isValid = true

  inputs.forEach((input) => {
    if (!input.value.trim()) {
      showError(input, "Ce champ est requis")
      isValid = false
    } else {
      clearError(input)
    }
  })

  return isValid
}

function showError(input, message) {
  clearError(input)
  const error = document.createElement("div")
  error.className = "error-message"
  error.textContent = message
  input.parentNode.appendChild(error)
  input.style.borderColor = "#ff4444"
}

function clearError(input) {
  const error = input.parentNode.querySelector(".error-message")
  if (error) {
    error.remove()
  }
  input.style.borderColor = ""
}

// Fonctions utilitaires
function showNotification(message, type = "info") {
  const notification = document.createElement("div")
  notification.className = `notification notification-${type}`
  notification.textContent = message

  document.body.appendChild(notification)

  setTimeout(() => {
    notification.style.opacity = "1"
    notification.style.transform = "translateY(0)"
  }, 100)

  setTimeout(() => {
    notification.style.opacity = "0"
    notification.style.transform = "translateY(-20px)"
    setTimeout(() => notification.remove(), 300)
  }, 3000)
}

// Gestion du localStorage
function saveToStorage(key, data) {
  try {
    localStorage.setItem(key, JSON.stringify(data))
  } catch (e) {
    console.error("Erreur de sauvegarde:", e)
  }
}

function getFromStorage(key) {
  try {
    const data = localStorage.getItem(key)
    return data ? JSON.parse(data) : null
  } catch (e) {
    console.error("Erreur de lecture:", e)
    return null
  }
}
