<?php
session_start();
require_once 'config/database.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: identification.php');
    exit();
}

$performance_id = isset($_GET['performance_id']) ? (int)$_GET['performance_id'] : 0;
$message = '';

if ($_POST) {
    $rating = (int)$_POST['rating'];
    $comment = trim($_POST['comment']);
    
    if ($rating >= 1 && $rating <= 5 && !empty($comment) && $performance_id) {
        $database = new Database();
        $db = $database->getConnection();
        
        // Vérifier si l'utilisateur a déjà donné un avis
        $check_query = "SELECT id FROM reviews WHERE user_id = :user_id AND performance_id = :performance_id";
        $check_stmt = $db->prepare($check_query);
        $check_stmt->bindParam(':user_id', $_SESSION['user_id']);
        $check_stmt->bindParam(':performance_id', $performance_id);
        $check_stmt->execute();
        
        if ($check_stmt->rowCount() > 0) {
            // Mettre à jour l'avis existant
            $update_query = "UPDATE reviews SET rating = :rating, comment = :comment, is_approved = 0 
                            WHERE user_id = :user_id AND performance_id = :performance_id";
            $update_stmt = $db->prepare($update_query);
            $update_stmt->bindParam(':rating', $rating);
            $update_stmt->bindParam(':comment', $comment);
            $update_stmt->bindParam(':user_id', $_SESSION['user_id']);
            $update_stmt->bindParam(':performance_id', $performance_id);
            $update_stmt->execute();
            $message = 'Votre avis a été mis à jour et sera modéré.';
        } else {
            // Créer un nouvel avis
            $insert_query = "INSERT INTO reviews (user_id, performance_id, rating, comment) 
                            VALUES (:user_id, :performance_id, :rating, :comment)";
            $insert_stmt = $db->prepare($insert_query);
            $insert_stmt->bindParam(':user_id', $_SESSION['user_id']);
            $insert_stmt->bindParam(':performance_id', $performance_id);
            $insert_stmt->bindParam(':rating', $rating);
            $insert_stmt->bindParam(':comment', $comment);
            $insert_stmt->execute();
            $message = 'Votre avis a été envoyé et sera modéré.';
        }
        
        // Log de l'action
        $log_query = "INSERT INTO logs (user_id, action, entity, entity_id, ip_address) 
                      VALUES (:user_id, 'create', 'review', :performance_id, :ip)";
        $log_stmt = $db->prepare($log_query);
        $log_stmt->bindParam(':user_id', $_SESSION['user_id']);
        $log_stmt->bindParam(':performance_id', $performance_id);
        $log_stmt->bindParam(':ip', $_SERVER['REMOTE_ADDR']);
        $log_stmt->execute();
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Avis - Nouvel Acte</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="container">
        <?php include 'includes/sidebar.php'; ?>

        <main class="main avis-page">
            <h2>Avis</h2>
            
            <?php if ($message): ?>
                <div class="success-message"><?php echo htmlspecialchars($message); ?></div>
            <?php endif; ?>
            
            <form method="POST" action="" class="avis-form">
                <input type="hidden" name="performance_id" value="<?php echo $performance_id; ?>">
                
                <div class="form-group">
                    <label for="message">Message</label>
                    <textarea id="message" name="comment" placeholder="Écris ton message..." required></textarea>
                </div>
                
                <div class="form-group">
                    <label>Note</label>
                    <div class="rating-group">
                        <span class="star" data-rating="1">☆</span>
                        <span class="star" data-rating="2">☆</span>
                        <span class="star" data-rating="3">☆</span>
                        <span class="star" data-rating="4">☆</span>
                        <span class="star" data-rating="5">☆</span>
                    </div>
                    <input type="hidden" name="rating" id="rating" value="0" required>
                </div>
                
                <button type="submit" class="btn-send">Envoyer</button>
            </form>
        </main>

        <!-- Sidebar droite avec recommandations -->
        <aside class="aside">
            <div class="profile">
                <img src="assets/images/avatar-placeholder.jpg" alt="Avatar"/>
                <div class="info">
                    <div><?php echo htmlspecialchars($_SESSION['user_name']); ?></div>
                    <div>@<?php echo strtolower(str_replace(' ', '', $_SESSION['user_name'])); ?></div>
                </div>
            </div>
            
            <div class="recommendations">
                <p class="section-title">Aimer par tes amis</p>
                <div class="list">
                    <!-- Contenu dynamique des recommandations -->
                </div>
            </div>
            
            <button class="btn-all">Voir tout</button>
        </aside>
    </div>

    <script src="assets/js/avis.js"></script>
</body>
</html>
