<?php
require_once 'config/database.php';

// Script pour créer un utilisateur admin avec le bon mot de passe hashé

$database = new Database();
$db = $database->getConnection();

// Données admin
$email = 'admin@nouvelacte.fr';
$password = 'admin123';
$display_name = 'Administrateur';
$role_id = 1; // Admin

// Hasher le mot de passe
$password_hash = password_hash($password, PASSWORD_DEFAULT);

try {
    // Supprimer l'admin existant s'il existe
    $delete_query = "DELETE FROM users WHERE email = :email";
    $delete_stmt = $db->prepare($delete_query);
    $delete_stmt->bindParam(':email', $email);
    $delete_stmt->execute();

    // Créer le nouvel admin
    $insert_query = "INSERT INTO users (email, password_hash, display_name, role_id) 
                     VALUES (:email, :password_hash, :display_name, :role_id)";
    $insert_stmt = $db->prepare($insert_query);
    $insert_stmt->bindParam(':email', $email);
    $insert_stmt->bindParam(':password_hash', $password_hash);
    $insert_stmt->bindParam(':display_name', $display_name);
    $insert_stmt->bindParam(':role_id', $role_id);
    
    if ($insert_stmt->execute()) {
        echo "✅ Utilisateur admin créé avec succès !<br>";
        echo "📧 Email: {$email}<br>";
        echo "🔑 Mot de passe: {$password}<br>";
        echo "🔐 Hash généré: {$password_hash}<br>";
        
        // Vérifier la création
        $check_query = "SELECT id, email, display_name, role_id FROM users WHERE email = :email";
        $check_stmt = $db->prepare($check_query);
        $check_stmt->bindParam(':email', $email);
        $check_stmt->execute();
        $user = $check_stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($user) {
            echo "<br>👤 Utilisateur trouvé:<br>";
            echo "ID: {$user['id']}<br>";
            echo "Email: {$user['email']}<br>";
            echo "Nom: {$user['display_name']}<br>";
            echo "Rôle ID: {$user['role_id']}<br>";
        }
        
    } else {
        echo "❌ Erreur lors de la création de l'utilisateur admin";
    }
    
} catch (PDOException $e) {
    echo "❌ Erreur de base de données: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Création Admin - Nouvel Acte</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 600px;
            margin: 50px auto;
            padding: 20px;
            background: #f5f5f5;
        }
        .container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h1 {
            color: #e30b17;
            text-align: center;
        }
        .info {
            background: #e8f5e8;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
            border-left: 4px solid #4caf50;
        }
        .actions {
            text-align: center;
            margin-top: 30px;
        }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            background: #e30b17;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin: 0 10px;
        }
        .btn:hover {
            background: #c5090f;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🎭 Nouvel Acte - Admin</h1>
        
        <div class="info">
            <h3>✅ Utilisateur admin créé !</h3>
            <p><strong>Vous pouvez maintenant vous connecter avec :</strong></p>
            <p>📧 <strong>Email :</strong> admin@nouvelacte.fr</p>
            <p>🔑 <strong>Mot de passe :</strong> admin123</p>
        </div>
        
        <div class="actions">
            <a href="identification.php" class="btn">🔐 Se connecter</a>
            <a href="index.html" class="btn">🏠 Accueil</a>
        </div>
    </div>
</body>
</html>
