<?php
require_once 'config/database.php';

// Script pour forcer la création d'un admin fonctionnel

$database = new Database();
$db = $database->getConnection();

$email = 'admin@nouvelacte.fr';
$password = 'admin123';

echo "<h2>🔧 Création forcée de l'admin</h2>";

try {
    // Supprimer l'admin existant (en gérant les contraintes)
    echo "🗑️ Suppression de l'admin existant...<br>";
    
    // Désactiver les contraintes temporairement
    $db->exec("SET FOREIGN_KEY_CHECKS = 0");
    
    // Supprimer toutes les données liées à cet email
    $db->exec("DELETE FROM logs WHERE user_id IN (SELECT id FROM users WHERE email = '$email')");
    $db->exec("DELETE FROM reviews WHERE user_id IN (SELECT id FROM users WHERE email = '$email')");
    $db->exec("DELETE FROM favorites WHERE user_id IN (SELECT id FROM users WHERE email = '$email')");
    $db->exec("DELETE FROM friends WHERE user_id IN (SELECT id FROM users WHERE email = '$email') OR friend_id IN (SELECT id FROM users WHERE email = '$email')");
    $db->exec("DELETE FROM group_members WHERE user_id IN (SELECT id FROM users WHERE email = '$email')");
    $db->exec("DELETE FROM `groups` WHERE owner_id IN (SELECT id FROM users WHERE email = '$email')");
    $db->exec("DELETE FROM reservation_items WHERE reservation_id IN (SELECT id FROM reservations WHERE user_id IN (SELECT id FROM users WHERE email = '$email'))");
    $db->exec("DELETE FROM reservations WHERE user_id IN (SELECT id FROM users WHERE email = '$email')");
    $db->exec("DELETE FROM users WHERE email = '$email'");
    
    // Réactiver les contraintes
    $db->exec("SET FOREIGN_KEY_CHECKS = 1");
    
    echo "✅ Ancien admin supprimé<br><br>";
    
    // Créer un nouveau hash
    $password_hash = password_hash($password, PASSWORD_DEFAULT);
    echo "🔐 Nouveau hash généré: " . substr($password_hash, 0, 30) . "...<br>";
    
    // Vérifier que le hash fonctionne
    if (password_verify($password, $password_hash)) {
        echo "✅ Hash vérifié avec succès<br>";
    } else {
        echo "❌ Erreur: Le hash ne fonctionne pas<br>";
        exit;
    }
    
    // S'assurer que le rôle admin existe
    $role_check = $db->query("SELECT id FROM roles WHERE name = 'admin'");
    if ($role_check->rowCount() == 0) {
        $db->exec("INSERT INTO roles (name) VALUES ('admin')");
        echo "✅ Rôle admin créé<br>";
    }
    
    // Créer le nouvel utilisateur admin
    $insert_query = "INSERT INTO users (email, password_hash, display_name, role_id) 
                     VALUES (:email, :password_hash, 'Administrateur', 1)";
    $insert_stmt = $db->prepare($insert_query);
    $insert_stmt->bindParam(':email', $email);
    $insert_stmt->bindParam(':password_hash', $password_hash);
    
    if ($insert_stmt->execute()) {
        $admin_id = $db->lastInsertId();
        echo "✅ <strong style='color: green;'>Nouvel admin créé avec l'ID: $admin_id</strong><br><br>";
        
        // Test final de connexion
        echo "<h3>🧪 Test final de connexion :</h3>";
        
        $test_query = "SELECT u.*, r.name as role_name FROM users u 
                       JOIN roles r ON u.role_id = r.id 
                       WHERE u.email = :email";
        $test_stmt = $db->prepare($test_query);
        $test_stmt->bindParam(':email', $email);
        $test_stmt->execute();
        
        if ($test_stmt->rowCount() > 0) {
            $user = $test_stmt->fetch(PDO::FETCH_ASSOC);
            
            echo "👤 Utilisateur trouvé: {$user['display_name']}<br>";
            echo "🔑 Rôle: {$user['role_name']}<br>";
            
            if (password_verify($password, $user['password_hash'])) {
                echo "✅ <strong style='color: green; font-size: 18px;'>CONNEXION TESTÉE AVEC SUCCÈS ! 🎉</strong><br>";
                echo "<br>🎭 <strong>Vous pouvez maintenant vous connecter avec :</strong><br>";
                echo "📧 <strong>Email:</strong> $email<br>";
                echo "🔑 <strong>Mot de passe:</strong> $password<br>";
            } else {
                echo "❌ <strong style='color: red;'>Erreur: Le test de connexion a échoué</strong><br>";
            }
        } else {
            echo "❌ <strong style='color: red;'>Erreur: Utilisateur non trouvé après création</strong><br>";
        }
        
    } else {
        echo "❌ <strong style='color: red;'>Erreur lors de la création de l'admin</strong><br>";
        print_r($insert_stmt->errorInfo());
    }
    
} catch (PDOException $e) {
    echo "❌ Erreur: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Force Create Admin - Nouvel Acte</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 800px;
            margin: 20px auto;
            padding: 20px;
            background: #f5f5f5;
            line-height: 1.6;
        }
        .container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h2, h3 {
            color: #e30b17;
        }
        .success {
            background: #d4edda;
            color: #155724;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
            border-left: 4px solid #28a745;
            font-size: 16px;
        }
        .actions {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
        }
        .btn {
            display: inline-block;
            padding: 15px 30px;
            background: #e30b17;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin: 0 10px;
            font-weight: bold;
            font-size: 16px;
        }
        .btn:hover {
            background: #c5090f;
        }
        .btn-secondary {
            background: #6c757d;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="success">
            <h3>🎉 Admin créé avec succès !</h3>
            <p><strong>L'utilisateur admin a été créé et testé. La connexion devrait maintenant fonctionner parfaitement.</strong></p>
            <p>📧 <strong>Email :</strong> admin@nouvelacte.fr</p>
            <p>🔑 <strong>Mot de passe :</strong> admin123</p>
        </div>
        
        <div class="actions">
            <a href="identification.php" class="btn">🔐 Se connecter maintenant</a>
            <a href="debug-login.php" class="btn btn-secondary">🔍 Diagnostic</a>
        </div>
    </div>
</body>
</html>
