<?php
session_start();
require_once 'config/database.php';

$error = '';

if ($_POST) {
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    
    if (!empty($email) && !empty($password)) {
        $database = new Database();
        $db = $database->getConnection();
        
        $query = "SELECT u.*, r.name as role_name FROM users u 
                  JOIN roles r ON u.role_id = r.id 
                  WHERE u.email = :email";
        $stmt = $db->prepare($query);
        $stmt->bindParam(':email', $email);
        $stmt->execute();
        
        if ($stmt->rowCount() > 0) {
            $user = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if (password_verify($password, $user['password_hash'])) {
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_name'] = $user['display_name'];
                $_SESSION['user_role'] = $user['role_name'];
                
                // Log de connexion
                $log_query = "INSERT INTO logs (user_id, action, ip_address) VALUES (:user_id, 'login', :ip)";
                $log_stmt = $db->prepare($log_query);
                $log_stmt->bindParam(':user_id', $user['id']);
                $log_stmt->bindParam(':ip', $_SERVER['REMOTE_ADDR']);
                $log_stmt->execute();
                
                if ($user['role_name'] === 'admin') {
                    header('Location: admin/dashboard.php');
                } else {
                    header('Location: dashboard.php');
                }
                exit();
            } else {
                $error = 'Mot de passe incorrect';
            }
        } else {
            $error = 'Email non trouvé';
        }
    } else {
        $error = 'Veuillez remplir tous les champs';
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nouvel Acte - Connexion</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body class="auth-page">
    <div class="auth-background">
        <!-- Logo -->
        <div class="logo">
            <a href="index.html">
                <div class="logo-icon"></div>
                <div class="logo-text">Nouvel Acte</div>
            </a>
        </div>

        <!-- Formulaire de connexion -->
        <div class="auth-card">
            <h1>Identifiez-vous</h1>
            
            <?php if ($error): ?>
                <div class="error-message"><?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <input type="email" name="email" placeholder="E-mail" required>
                <input type="password" name="password" placeholder="Mot de passe" required>
                <button type="submit">M'identifier</button>
            </form>
            
            <div class="auth-links">
                <a href="register.php">Pas encore de compte ? S'inscrire</a>
            </div>
        </div>
    </div>
</body>
</html>
