<?php
// Script simple pour tester les hashs de mots de passe

$password = 'admin123';

echo "<h2>🧪 Test des hashs de mots de passe</h2>";

// Générer plusieurs hashs
for ($i = 1; $i <= 3; $i++) {
    $hash = password_hash($password, PASSWORD_DEFAULT);
    echo "<strong>Hash $i :</strong><br>";
    echo "<code>$hash</code><br>";
    
    // Tester le hash
    if (password_verify($password, $hash)) {
        echo "✅ <span style='color: green;'>Hash $i fonctionne</span><br><br>";
    } else {
        echo "❌ <span style='color: red;'>Hash $i ne fonctionne pas</span><br><br>";
    }
}

// Tester le hash actuel de la base
require_once 'config/database.php';
$database = new Database();
$db = $database->getConnection();

$query = "SELECT password_hash FROM users WHERE email = 'admin@nouvelacte.fr'";
$stmt = $db->prepare($query);
$stmt->execute();

if ($stmt->rowCount() > 0) {
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "<strong>Hash actuel en base :</strong><br>";
    echo "<code>{$user['password_hash']}</code><br>";
    
    if (password_verify($password, $user['password_hash'])) {
        echo "✅ <span style='color: green;'>Le hash en base fonctionne</span><br>";
    } else {
        echo "❌ <span style='color: red;'>Le hash en base ne fonctionne pas</span><br>";
    }
} else {
    echo "❌ Aucun utilisateur admin trouvé en base<br>";
}
?>
