<?php
require_once 'db.php';
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: client_login.php');
    exit();
}
$user_id = (int)$_SESSION['user_id'];
$message = '';

// 1. TRAITEMENT : ENVOI D'UNE DEMANDE D'AMI
if (isset($_POST['add_ami_email'])) {
    $email = trim($_POST['add_ami_email']);
    if ($email && filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $user = $conn->query("SELECT id FROM utilisateurs WHERE email = '".$conn->real_escape_string($email)."' AND id != $user_id")->fetch_assoc();
        if ($user) {
            $ami_id = (int)$user['id'];
            // Vérifier si déjà amis ou demande existante
            $verif = $conn->query("SELECT * FROM amis WHERE (utilisateur_id = $user_id AND ami_id = $ami_id) OR (utilisateur_id = $ami_id AND ami_id = $user_id)");
            if ($verif->num_rows == 0) {
                $conn->query("INSERT INTO amis (utilisateur_id, ami_id, statut) VALUES ($user_id, $ami_id, 'en_attente')");
                $message = "Demande envoyée !";
            } else {
                $message = "Déjà ami ou demande en cours.";
            }
        } else {
            $message = "Utilisateur introuvable.";
        }
    } else {
        $message = "Email invalide.";
    }
}
// 2. TRAITEMENT : ACCEPTER/REFUSER UNE DEMANDE
if (isset($_POST['action']) && isset($_POST['demande_id'])) {
    $demande_id = (int)$_POST['demande_id'];
    if ($_POST['action'] === 'accepter') {
        $conn->query("UPDATE amis SET statut = 'accepte' WHERE id = $demande_id AND ami_id = $user_id");
    } elseif ($_POST['action'] === 'refuser') {
        $conn->query("UPDATE amis SET statut = 'refuse' WHERE id = $demande_id AND ami_id = $user_id");
    }
}
// 3. TRAITEMENT : SUPPRIMER UN AMI
if (isset($_POST['delete_ami_id'])) {
    $ami_id = (int)$_POST['delete_ami_id'];
    $conn->query("DELETE FROM amis WHERE (utilisateur_id = $user_id AND ami_id = $ami_id) OR (utilisateur_id = $ami_id AND ami_id = $user_id)");
}
// 4. AFFICHAGE : AMIS ACCEPTÉS
$amis = $conn->query("
    SELECT u.id, u.nom, u.prenom, u.email
    FROM utilisateurs u
    JOIN amis a ON (
        (a.utilisateur_id = $user_id AND a.ami_id = u.id)
        OR (a.ami_id = $user_id AND a.utilisateur_id = u.id)
    )
    WHERE a.statut = 'accepte' AND u.id != $user_id
    ORDER BY u.nom, u.prenom
");
// 5. AFFICHAGE : DEMANDES REÇUES
$recu = $conn->query("
    SELECT a.id, u.nom, u.prenom, u.email
    FROM amis a
    JOIN utilisateurs u ON u.id = a.utilisateur_id
    WHERE a.ami_id = $user_id AND a.statut = 'en_attente'
");
// 6. AFFICHAGE : DEMANDES ENVOYÉES
$envoyees = $conn->query("
    SELECT a.id, u.nom, u.prenom, u.email
    FROM amis a
    JOIN utilisateurs u ON u.id = a.ami_id
    WHERE a.utilisateur_id = $user_id AND a.statut = 'en_attente'
");
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Amis</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body {
            min-height: 100vh;
            margin: 0;
            background: linear-gradient(135deg, #121212 0%, #1b1b1b 100%);
            font-family: 'Montserrat', Arial, sans-serif;
            color: #fff;
        }
        .container {
            display: flex;
            min-height: 100vh;
            gap: 2rem;
            padding: 2rem 1rem;
        }
        .sidebar, .rightbar, .main-content, .popular-card, .search-bar, .genres-bar, .profile-box, .suggestion-list, .agenda-card {
            background: rgba(255,255,255,0.13);
            border: 1px solid rgba(255,255,255,0.18);
            border-radius: 1.5em;
            box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
        }
        .sidebar, .rightbar {
            min-width: 220px;
            max-width: 270px;
            padding: 2rem 1.2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
        }
        .sidebar h2 {
            font-family: 'Montserrat', Arial, sans-serif;
            font-size: 1.4rem;
            font-weight: 700;
            letter-spacing: 2px;
            margin-bottom: 2rem;
            color: #fff;
            text-transform: uppercase;
        }
        .sidebar nav ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .sidebar nav ul li {
            margin-bottom: 1rem;
        }
        .sidebar nav ul li a {
            display: flex;
            align-items: center;
            gap: 0.7rem;
            color: #fff;
            text-decoration: none;
            font-size: 1.08rem;
            font-weight: 600;
            padding: 0.6rem 1.2rem;
            border-radius: 1em;
            background: rgba(255,255,255,0.10);
            border: 1px solid rgba(255,255,255,0.18);
            transition: transform 0.3s, background 0.3s, box-shadow 0.3s, color 0.3s;
        }
        .sidebar nav ul li a.active, .sidebar nav ul li a:hover {
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            box-shadow: 0 1px 4px #bb86fc33;
            transition: background 0.45s, color 0.45s, box-shadow 0.45s;
        }
        .main-content {
            flex: 1;
            padding: 2rem 2rem 2rem 2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
        }
        .main-content h1 {
            font-family: 'Montserrat', Arial, sans-serif;
            font-size: 2.3rem;
            font-weight: 700;
            letter-spacing: 2px;
            margin-bottom: 1.5rem;
            color: #fff;
            text-shadow: 0 2px 16px #0008;
        }
        .popular-grid {
            display: flex;
            flex-wrap: wrap;
            gap: 2rem;
            justify-content: flex-start;
        }
        .popular-card {
            min-width: 120px;
            max-width: 120px;
            display: flex;
            flex-direction: column;
            align-items: center;
            border: 1px solid rgba(255,255,255,0.18);
            background: rgba(255,255,255,0.13);
            box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
            border-radius: 1.5em;
            padding: 1.2rem 1rem 1.2rem 1rem;
            transition: transform 0.3s, box-shadow 0.3s;
            will-change: transform;
            cursor: pointer;
        }
        .popular-card:hover {
            transform: scale(1.05);
            box-shadow: 0 16px 48px 0 #03dac655;
        }
        .popular-img {
            width: 80px;
            height: 110px;
            background: #bdbdbd;
            border-radius: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 0 auto;
            position: relative;
            overflow: hidden;
        }
        .popular-img img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 16px;
            display: block;
        }
        .popular-title-card {
            color: #fff;
            font-size: 0.85rem;
            font-weight: bold;
            margin-top: 0.3rem;
            margin-bottom: 0.05rem;
            text-align: center;
            width: 100%;
        }
        .footer-bar {
            width: 100vw;
            background: rgba(18,18,18,0.98);
            color: #fff;
            font-family: 'Montserrat', Arial, sans-serif;
            text-align: center;
            padding: 1.2em 0 1.2em 0;
            font-size: 1.05rem;
            border-top: 1.5px solid #232323;
            box-shadow: 0 -2px 16px #bb86fc22;
            letter-spacing: 0.2px;
            margin-top: 2.5em;
        }
        .footer-bar a {
            color: #bb86fc;
            text-decoration: none;
            font-weight: 700;
            margin: 0 0.7em;
            border-radius: 0.7em;
            padding: 0.2em 0.7em;
            transition: background 0.2s, color 0.2s;
        }
        .footer-bar a:hover {
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            box-shadow: 0 1px 4px #bb86fc33;
        }
        @media (max-width: 900px) {
            .container { flex-direction: column; gap: 1rem; }
            .sidebar, .rightbar { width: 100%; min-width: 0; max-width: 100%; }
            .main-content { padding: 1rem; }
        }
        @media (max-width: 600px) {
            .container { flex-direction: column; gap: 0.5rem; padding: 0.5rem; }
            .sidebar, .rightbar, .main-content { padding: 1rem; }
        }
        .btn {
            padding: 0.6rem 1.2rem;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-weight: 500;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }
        .btn-primary {
            background-color: #6c5ce7;
            color: white;
        }
        .btn-primary:hover {
            background-color: #5649b8;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        .rightbar-btn {
            display: inline-block;
            text-align: center;
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            font-weight: 700;
            border-radius: 1.2rem;
            padding: 0.7rem 1.5rem;
            box-shadow: 0 2px 12px #bb86fc22;
            text-decoration: none;
            border: none;
            font-size: 1.08rem;
            transition: background 0.2s, box-shadow 0.2s, color 0.2s, transform 0.2s;
            cursor: pointer;
        }
        .rightbar-btn:hover {
            background: linear-gradient(90deg, #e50914 40%, #bb86fc 100%);
            color: #fff;
            box-shadow: 0 4px 16px #e5091444;
            transform: translateY(-2px);
        }
    </style>
</head>
<body>
<div class="container">
    <!-- Sidebar gauche -->
    <aside class="sidebar">
        <h2><span class="material-icons" style="color:#bb86fc;margin-right:8px;">theaters</span>NOUVEL ACTE</h2>
        <nav>
            <ul>
                <li><a href="client.php"><span class="material-icons" style="margin-right:8px;">home</span>Accueil</a></li>
                <li><a href="agenda_culturel.php"><span class="material-icons" style="margin-right:8px;">event</span>Agenda culturel</a></li>
                <li><a href="favoris.php"><span class="material-icons" style="margin-right:8px;">star</span>Favoris</a></li>
                <li><a href="mes_reservations.php"><span class="material-icons" style="margin-right:8px;">confirmation_number</span>Mes réservations</a></li>
                <li><a href="genres_client.php"><span class="material-icons" style="margin-right:8px;">category</span>Genres</a></li>
                <li><a href="partenaire_client.php"><span class="material-icons" style="margin-right:8px;">business_center</span>Partenaires</a></li>
                <li style="margin-top:2rem;"><b>Sociale</b></li>
                <li><a href="amis.php" class="active"><span class="material-icons" style="margin-right:8px;">group</span>Amis</a></li>
                <li><a href="groupes.php"><span class="material-icons" style="margin-right:8px;">groups</span>Groupe</a></li>
                <li style="margin-top:2rem;"><b>Général</b></li>
                <li><a href="abonnement.php"><span class="material-icons" style="margin-right:8px;">card_membership</span>Abonnement</a></li>
                <li><a href="client_logout.php"><span class="material-icons" style="margin-right:8px;">logout</span>Se déconnecter</a></li>
                <li><a href="map.php"><span class="material-icons" style="margin-right:8px;">map</span>Carte des spectacles</a></li>
            </ul>
        </nav>
    </aside>
    <!-- Contenu principal -->
    <main class="main-content">
        <h1>Mes Amis</h1>
        <?php if ($message): ?><div style="color:#e50914;font-weight:bold;margin-bottom:1rem;"> <?= htmlspecialchars($message) ?> </div><?php endif; ?>
        <!-- Formulaire d'ajout d'ami -->
        <form method="post" style="margin-bottom:2.5rem;display:flex;gap:1rem;align-items:center;">
            <input type="email" name="add_ami_email" placeholder="Email de l'ami à ajouter" required style="padding:0.7rem 1.2rem;border-radius:2em;border:1.5px solid #333;background:#181818;color:#fff;font-size:1.1rem;">
            <button type="submit" class="rightbar-btn">Ajouter</button>
        </form>
        <!-- Demandes reçues -->
        <h2 style="font-size:1.3rem;color:#fff;margin-bottom:1rem;">Demandes reçues</h2>
        <div class="popular-grid">
            <?php if ($recu && $recu->num_rows > 0): ?>
                <?php while ($d = $recu->fetch_assoc()): ?>
                <div class="popular-card">
                    <div class="popular-img">
                        <span class="material-icons" style="font-size:40px;color:#bb86fc;">person_add</span>
                    </div>
                    <div class="popular-title-card"><?= htmlspecialchars($d['prenom'] . ' ' . $d['nom']) ?></div>
                    <form method="post" class="ami-actions">
                        <input type="hidden" name="demande_id" value="<?= $d['id'] ?>">
                        <button type="submit" name="action" value="accepter" class="btn-accept">Accepter</button>
                        <button type="submit" name="action" value="refuser" class="btn-refuse">Refuser</button>
                    </form>
                </div>
                <?php endwhile; ?>
            <?php else: ?>
                <div style="color:#888;">Aucune demande reçue.</div>
            <?php endif; ?>
        </div>
        <!-- Demandes envoyées -->
        <h2 style="font-size:1.3rem;color:#fff;margin:2rem 0 1rem 0;">Demandes envoyées</h2>
        <div class="popular-grid">
            <?php if ($envoyees && $envoyees->num_rows > 0): ?>
                <?php while ($d = $envoyees->fetch_assoc()): ?>
                <div class="popular-card">
                    <div class="popular-img">
                        <span class="material-icons" style="font-size:40px;color:#bb86fc;">hourglass_top</span>
                    </div>
                    <div class="popular-title-card"><?= htmlspecialchars($d['prenom'] . ' ' . $d['nom']) ?></div>
                    <div style="margin-top:1rem;color:#e50914;font-weight:bold;">En attente</div>
                </div>
                <?php endwhile; ?>
            <?php else: ?>
                <div style="color:#888;">Aucune demande envoyée.</div>
            <?php endif; ?>
        </div>
        <!-- Amis acceptés -->
        <h2 style="font-size:1.3rem;color:#fff;margin:2rem 0 1rem 0;">Mes amis</h2>
        <div class="popular-grid">
            <?php if ($amis && $amis->num_rows > 0): ?>
                <?php while ($a = $amis->fetch_assoc()): ?>
                <div class="popular-card">
                    <div class="popular-img">
                        <span class="material-icons" style="font-size:40px;color:#bb86fc;">account_circle</span>
                    </div>
                    <div class="popular-title-card"><?= htmlspecialchars($a['prenom'] . ' ' . $a['nom']) ?></div>
                    <form method="post" class="ami-actions">
                        <input type="hidden" name="delete_ami_id" value="<?= $a['id'] ?>">
                        <button type="submit" class="btn-delete">Supprimer</button>
                    </form>
                </div>
                <?php endwhile; ?>
            <?php else: ?>
                <div style="color:#888;">Aucun ami pour le moment.</div>
            <?php endif; ?>
        </div>
    </main>
    <!-- Sidebar droite -->
    <aside class="rightbar">
        <?php include 'rightbar_favoris_amis.php'; ?>
    </aside>
</div>
<footer class="footer-bar">
    <a href="confidentialite.php">Politiques de confidentialité</a> · <a href="mentions_legales.php">Mentions légales</a>
</footer>
</body>
</html> 