<?php
require_once 'db.php';
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: client_login.php');
    exit();
}
$user_id = $_SESSION['user_id'];
// Récupérer les amis acceptés
$amis_ids = [];
$res = $conn->query("SELECT CASE WHEN utilisateur_id = $user_id THEN ami_id ELSE utilisateur_id END as ami_id FROM amis WHERE (utilisateur_id = $user_id OR ami_id = $user_id) AND statut = 'accepte'");
while ($row = $res->fetch_assoc()) {
    $amis_ids[] = (int)$row['ami_id'];
}
$favoris_amis = [];
if ($amis_ids) {
    $ids_str = implode(',', $amis_ids);
    // Récupérer tous les favoris de ces amis (pas de limite)
    $sql = "SELECT s.*, u.prenom, u.nom FROM favoris f JOIN spectacles s ON f.spectacle_id = s.id JOIN utilisateurs u ON f.utilisateur_id = u.id WHERE f.utilisateur_id IN ($ids_str) GROUP BY s.id, u.id ORDER BY f.date_ajout DESC";
    $favoris_amis = $conn->query($sql);
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Mis en favori par tes amis</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body {
            min-height: 100vh;
            margin: 0;
            background: linear-gradient(135deg, #121212 0%, #1b1b1b 100%);
            font-family: 'Montserrat', Arial, sans-serif;
            color: #fff;
        }
        .container {
            display: flex;
            min-height: 100vh;
            gap: 2rem;
            padding: 2rem 1rem;
        }
        .sidebar {
            min-width: 220px;
            max-width: 270px;
            padding: 2rem 1.2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
            background: rgba(255,255,255,0.13);
            border: 1px solid rgba(255,255,255,0.18);
            border-radius: 1.5em;
            box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
        }
        .sidebar h2 {
            font-family: 'Montserrat', Arial, sans-serif;
            font-size: 1.4rem;
            font-weight: 700;
            letter-spacing: 2px;
            margin-bottom: 2rem;
            color: #fff;
            text-transform: uppercase;
        }
        .sidebar nav ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .sidebar nav ul li {
            margin-bottom: 1rem;
        }
        .sidebar nav ul li a {
            display: flex;
            align-items: center;
            gap: 0.7rem;
            color: #fff;
            text-decoration: none;
            font-size: 1.08rem;
            font-weight: 600;
            padding: 0.6rem 1.2rem;
            border-radius: 1em;
            background: rgba(255,255,255,0.10);
            border: 1px solid rgba(255,255,255,0.18);
            transition: transform 0.3s, background 0.3s, box-shadow 0.3s, color 0.3s;
        }
        .sidebar nav ul li a.active, .sidebar nav ul li a:hover {
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            box-shadow: 0 1px 4px #bb86fc33;
            transition: background 0.45s, color 0.45s, box-shadow 0.45s;
        }
        .main-content {
            flex: 1;
            padding: 2rem 2rem 2rem 2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
            align-items: center;
        }
        .main-content h1 {
            font-size: 2.1rem;
            font-weight: 800;
            color: #FFD600;
            margin-bottom: 1.5rem;
            letter-spacing: 1px;
            text-shadow: 0 2px 16px #0008;
        }
        .favoris-list {
            width: 100%;
            max-width: 540px;
            display: flex;
            flex-direction: column;
            gap: 1.3rem;
        }
        .favori-card {
            display: flex;
            align-items: center;
            gap: 1.1rem;
            background: #181818;
            border-radius: 1.2em;
            box-shadow: 0 2px 12px #bb86fc22;
            padding: 1.1rem 1.5rem;
            position: relative;
        }
        .favori-img {
            width: 62px;
            height: 62px;
            border-radius: 1em;
            background: #232323;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }
        .favori-img img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 1em;
        }
        .favori-info {
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            gap: 0.2em;
        }
        .favori-titre {
            font-size: 1.13rem;
            font-weight: 700;
            color: #fff;
            margin-bottom: 0.1em;
        }
        .favori-ami {
            color: #FFD600;
            font-size: 0.98rem;
            font-weight: 600;
        }
        .favori-desc {
            color: #bbb;
            font-size: 0.97rem;
            margin-top: 0.2em;
            max-width: 340px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }
        .no-favoris {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.7em;
            background: #232323;
            color: #bbb;
            border-radius: 1em;
            padding: 1.1em 1.5em;
            font-size: 1.08rem;
            font-weight: 500;
            box-shadow: 0 1px 6px #0002;
            text-align: center;
            margin-top: 2em;
        }
        .footer-bar {
            width: 100vw;
            background: rgba(18,18,18,0.98);
            color: #fff;
            font-family: 'Montserrat', Arial, sans-serif;
            text-align: center;
            padding: 1.2em 0 1.2em 0;
            font-size: 1.05rem;
            border-top: 1.5px solid #232323;
            box-shadow: 0 -2px 16px #bb86fc22;
            letter-spacing: 0.2px;
            margin-top: 2.5em;
        }
        .footer-bar a {
            color: #bb86fc;
            text-decoration: none;
            font-weight: 700;
            margin: 0 0.7em;
            border-radius: 0.7em;
            padding: 0.2em 0.7em;
            transition: background 0.2s, color 0.2s;
        }
        .footer-bar a:hover {
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            box-shadow: 0 1px 4px #bb86fc33;
        }
        .rightbar {
            min-width: 220px;
            max-width: 270px;
            padding: 2rem 1.2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
        }
        @media (max-width: 900px) {
            .container { flex-direction: column; gap: 1rem; }
            .sidebar, .rightbar { width: 100%; min-width: 0; max-width: 100%; }
            .main-content { padding: 1rem; }
        }
        @media (max-width: 600px) {
            .container { flex-direction: column; gap: 0.5rem; padding: 0.5rem; }
            .sidebar, .rightbar, .main-content { padding: 1rem; }
        }
    </style>
</head>
<body>
<div class="container">
    <!-- Sidebar gauche -->
    <aside class="sidebar">
        <h2><span class="material-icons" style="color:#bb86fc;margin-right:8px;">theaters</span>NOUVEL ACTE</h2>
        <nav>
            <ul>
                <li><a href="client.php"><span class="material-icons" style="margin-right:8px;">home</span>Accueil</a></li>
                <li><a href="agenda_culturel.php"><span class="material-icons" style="margin-right:8px;">event</span>Agenda culturel</a></li>
                <li><a href="favoris.php"><span class="material-icons" style="margin-right:8px;">star</span>Favoris</a></li>
                <li><a href="mes_reservations.php"><span class="material-icons" style="margin-right:8px;">confirmation_number</span>Mes réservations</a></li>
                <li><a href="genres_client.php"><span class="material-icons" style="margin-right:8px;">category</span>Genres</a></li>
                <li><a href="partenaire_client.php"><span class="material-icons" style="margin-right:8px;">business_center</span>Partenaires</a></li>
                <li style="margin-top:2rem;"><b>Sociale</b></li>
                <li><a href="amis.php"><span class="material-icons" style="margin-right:8px;">group</span>Amis</a></li>
                <li><a href="groupes.php"><span class="material-icons" style="margin-right:8px;">groups</span>Groupe</a></li>
                <li style="margin-top:2rem;"><b>Général</b></li>
                <li><a href="abonnement.php"><span class="material-icons" style="margin-right:8px;">card_membership</span>Abonnement</a></li>
                <li><a href="client_logout.php"><span class="material-icons" style="margin-right:8px;">logout</span>Se déconnecter</a></li>
                <li><a href="map.php"><span class="material-icons" style="margin-right:8px;">map</span>Carte des spectacles</a></li>
            </ul>
        </nav>
    </aside>
    <!-- Contenu principal -->
    <main class="main-content">
        <h1>Mis en favori par tes amis</h1>
        <?php if ($favoris_amis && $favoris_amis->num_rows > 0): ?>
            <div class="favoris-list">
                <?php while ($s = $favoris_amis->fetch_assoc()): ?>
                    <div class="favori-card">
                        <div class="favori-img">
                            <?php if ($s['image']): ?>
                                <img src="uploads/<?= htmlspecialchars($s['image']) ?>" alt="Affiche">
                            <?php else: ?>
                                <span class="material-icons" style="font-size:38px;color:#888;">image</span>
                            <?php endif; ?>
                        </div>
                        <div class="favori-info">
                            <div class="favori-titre"><?= htmlspecialchars($s['titre']) ?></div>
                            <div class="favori-ami">par <?= htmlspecialchars($s['prenom']) ?> <?= htmlspecialchars($s['nom']) ?></div>
                            <div class="favori-desc"><?= htmlspecialchars(mb_strimwidth(strip_tags($s['description'] ?? ''), 0, 80, '...')) ?></div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        <?php else: ?>
            <div class="no-favoris">
                <span class="material-icons" style="font-size: 1.3em; color: #888;">star_border</span>
                Aucun favori d'amis pour le moment.
            </div>
        <?php endif; ?>
    </main>
    <!-- Sidebar droite -->
    <aside class="rightbar">
        <?php include 'rightbar_favoris_amis.php'; ?>
    </aside>
</div>
<footer class="footer-bar">
    <a href="confidentialite.php">Politiques de confidentialité</a> · <a href="mentions_legales.php">Mentions légales</a>
</footer>
</body>
</html> 