<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Nouvel Acte - Vivez le spectacle</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="landing.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@700;400&display=swap" rel="stylesheet">
</head>
<body>
    <div class="landing-bg">
        <div class="overlay"></div>
        <header>
            <div class="logo">
                <span class="icon">🎭</span>
                <span class="brand">NOUVEL ACTE</span>
            </div>
        </header>
        <main>
            <h1>POURQUOI SCROLLER<br>QUAND ON PEUT LE VIVRE</h1>
            <p class="desc">
                Découvrez une nouvelle façon de vivre le spectacle. Réservez vos places, retrouvez vos amis, et plongez dans l'expérience théâtrale comme jamais auparavant.
            </p>
            <a href="client_login.php" class="cta-btn">Découvrir</a>
        </main>
    </div>
</body>
<div id="cookie-banner" role="dialog" aria-modal="true" aria-label="Informations sur les cookies" tabindex="-1" style="display:none;position:fixed;bottom:24px;left:24px;z-index:9999;min-width:240px;max-width:340px;width:100%;background:rgba(30,30,40,0.98);color:#fff;border-radius:1.2em;box-shadow:0 4px 24px #0008;padding:1em 1.1em 1em 1.1em;align-items:center;gap:0.8em;font-family:'Montserrat',Arial,sans-serif;flex-direction:column;outline:none;">
    <div style="display:flex;align-items:center;gap:0.5em;margin-bottom:0.5em;">
        <span class="material-icons" style="font-size:1.3em;color:#FFD600;">privacy_tip</span>
        <span style="font-size:1em;font-weight:700;">Gestion des cookies</span>
    </div>
    <div style="font-size:0.97em;line-height:1.5;margin-bottom:0.7em;">
        Ce site utilise des cookies pour garantir la meilleure expérience utilisateur, mesurer l'audience et proposer des contenus adaptés. <span style="color:#FFD600;font-weight:600;">Aucun cookie publicitaire n'est utilisé.</span>
    </div>
    <div style="display:flex;gap:0.5em;width:100%;justify-content:flex-end;">
        <button id="cookie-settings" style="background:#232323;color:#FFD600;border:none;border-radius:1em;padding:0.5em 1em;font-size:0.97em;font-weight:600;cursor:pointer;outline:none;transition:background 0.2s;">Paramétrer</button>
        <button id="cookie-accept" style="background:#FFD600;color:#232323;border:none;border-radius:1em;padding:0.5em 1em;font-size:0.97em;font-weight:700;cursor:pointer;outline:none;transition:background 0.2s;">Accepter</button>
    </div>
</div>

<!-- Modal de gestion des préférences cookies -->
<div id="cookie-modal" role="dialog" aria-modal="true" aria-label="Préférences cookies" tabindex="-1" style="display:none;position:fixed;bottom:0;left:0;right:0;top:0;z-index:10000;background:rgba(20,20,30,0.85);align-items:center;justify-content:center;">
  <div style="background:#23232b;color:#fff;border-radius:1.2em;box-shadow:0 4px 24px #0008;padding:2em 2.2em;max-width:95vw;width:370px;outline:none;display:flex;flex-direction:column;gap:1.2em;">
    <div style="display:flex;align-items:center;gap:0.7em;">
      <span class="material-icons" style="font-size:1.5em;color:#FFD600;">tune</span>
      <span style="font-size:1.13em;font-weight:700;">Préférences cookies</span>
    </div>
    <div style="font-size:1em;line-height:1.5;">
      Gérez vos préférences de cookies. Certains cookies sont nécessaires au fonctionnement du site et ne peuvent pas être désactivés.
    </div>
    <div style="background:#18181f;border-radius:0.8em;padding:1em 1.2em;display:flex;flex-direction:column;gap:0.7em;">
      <div style="display:flex;align-items:center;justify-content:space-between;">
        <span style="font-weight:600;">Cookies essentiels</span>
        <span style="color:#FFD600;font-size:1.1em;">Toujours activés</span>
      </div>
      <div style="font-size:0.98em;color:#bbb;">Nécessaires au fonctionnement du site (sécurité, session, accès...)</div>
      <div style="display:flex;align-items:center;justify-content:space-between;">
        <span style="font-weight:600;">Mesure d'audience</span>
        <label style="display:flex;align-items:center;gap:0.4em;cursor:pointer;">
          <input type="checkbox" id="cookie-analytics" style="accent-color:#FFD600;width:1.1em;height:1.1em;" aria-checked="false">
          <span id="cookie-analytics-label" style="font-size:0.98em;">Autoriser</span>
        </label>
      </div>
      <div style="font-size:0.98em;color:#bbb;">Permet d'améliorer le site grâce à des statistiques anonymes.</div>
    </div>
    <div style="display:flex;gap:0.7em;justify-content:flex-end;">
      <button id="cookie-modal-cancel" style="background:#232323;color:#FFD600;border:none;border-radius:1em;padding:0.6em 1.3em;font-size:1em;font-weight:600;cursor:pointer;outline:none;transition:background 0.2s;">Annuler</button>
      <button id="cookie-modal-validate" style="background:#FFD600;color:#232323;border:none;border-radius:1em;padding:0.6em 1.3em;font-size:1em;font-weight:700;cursor:pointer;outline:none;transition:background 0.2s;">Valider</button>
    </div>
  </div>
</div>

<script>
// RGPD Cookie Banner Logic
function setCookie(name, value, days) {
    var expires = '';
    if (days) {
        var date = new Date();
        date.setTime(date.getTime() + (days*24*60*60*1000));
        expires = '; expires=' + date.toUTCString();
    }
    document.cookie = name + '=' + (value || '')  + expires + '; path=/';
}
function getCookie(name) {
    var nameEQ = name + '=';
    var ca = document.cookie.split(';');
    for(var i=0;i < ca.length;i++) {
        var c = ca[i];
        while (c.charAt(0)==' ') c = c.substring(1,c.length);
        if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
    }
    return null;
}
window.addEventListener('DOMContentLoaded', function() {
    if (!getCookie('nouvelacte_cookies')) {
        document.getElementById('cookie-banner').style.display = 'flex';
    }
});
document.addEventListener('click', function(e) {
    if (e.target.id === 'cookie-accept') {
        setCookie('nouvelacte_cookies', JSON.stringify({essential:true,analytics:true}), 365);
        document.getElementById('cookie-banner').style.display = 'none';
    }
    if (e.target.id === 'cookie-settings') {
        document.getElementById('cookie-modal').style.display = 'flex';
        document.getElementById('cookie-modal').focus();
        // Préremplir la case analytics selon cookie existant
        var pref = getCookie('nouvelacte_cookies');
        if (pref) {
            try {
                var obj = JSON.parse(pref);
                document.getElementById('cookie-analytics').checked = !!obj.analytics;
            } catch(e) { document.getElementById('cookie-analytics').checked = true; }
        } else {
            document.getElementById('cookie-analytics').checked = true;
        }
    }
    if (e.target.id === 'cookie-modal-cancel') {
        document.getElementById('cookie-modal').style.display = 'none';
    }
    if (e.target.id === 'cookie-modal-validate') {
        var analytics = document.getElementById('cookie-analytics').checked;
        setCookie('nouvelacte_cookies', JSON.stringify({essential:true,analytics:analytics}), 365);
        document.getElementById('cookie-modal').style.display = 'none';
        document.getElementById('cookie-banner').style.display = 'none';
    }
});
</script>

<link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
</html> 