<?php
require_once 'db.php';
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: client_login.php');
    exit();
}
$user_id = (int)$_SESSION['user_id'];
// Récupérer toutes les villes distinctes
$villes = $conn->query("SELECT DISTINCT ville FROM salles WHERE latitude IS NOT NULL AND longitude IS NOT NULL ORDER BY ville");
$selected_ville = isset($_GET['ville']) ? $conn->real_escape_string($_GET['ville']) : '';
// Récupérer représentations avec coordonnées, filtrées par ville si besoin
$sql = "SELECT r.id, s.titre, s.image, sa.nom AS salle, sa.ville, r.date, r.heure, sa.latitude, sa.longitude
        FROM representations r
        JOIN spectacles s ON r.spectacle_id = s.id
        JOIN salles sa ON r.salle_id = sa.id
        WHERE sa.latitude IS NOT NULL AND sa.longitude IS NOT NULL";
if ($selected_ville) $sql .= " AND sa.ville = '" . $selected_ville . "'";
$sql .= " ORDER BY r.date DESC, r.heure DESC";
$reps = $conn->query($sql);
$data = [];
while ($row = $reps->fetch_assoc()) {
    $data[] = $row;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Carte des spectacles</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
    <style>
        body {
            min-height: 100vh;
            margin: 0;
            background: linear-gradient(135deg, #121212 0%, #1b1b1b 100%);
            font-family: 'Montserrat', Arial, sans-serif;
            color: #fff;
        }
        .container {
            display: flex;
            min-height: 100vh;
            gap: 2rem;
            padding: 2rem 1rem;
        }
        .sidebar {
            min-width: 220px;
            max-width: 270px;
            padding: 2rem 1.2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
            background: rgba(255,255,255,0.13);
            border: 1px solid rgba(255,255,255,0.18);
            border-radius: 1.5em;
            box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
        }
        .sidebar h2 {
            font-family: 'Montserrat', Arial, sans-serif;
            font-size: 1.4rem;
            font-weight: 700;
            letter-spacing: 2px;
            margin-bottom: 2rem;
            color: #fff;
            text-transform: uppercase;
        }
        .sidebar nav ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .sidebar nav ul li {
            margin-bottom: 1rem;
        }
        .sidebar nav ul li a {
            display: flex;
            align-items: center;
            gap: 0.7rem;
            color: #fff;
            text-decoration: none;
            font-size: 1.08rem;
            font-weight: 600;
            padding: 0.6rem 1.2rem;
            border-radius: 1em;
            background: rgba(255,255,255,0.10);
            border: 1px solid rgba(255,255,255,0.18);
            transition: transform 0.3s, background 0.3s, box-shadow 0.3s, color 0.3s;
        }
        .sidebar nav ul li a.active, .sidebar nav ul li a:hover {
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            box-shadow: 0 1px 4px #bb86fc33;
            transition: background 0.45s, color 0.45s, box-shadow 0.45s;
        }
        .main-content {
            flex: 1;
            padding: 2rem 2rem 2rem 2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
        }
        .main-content h1 {
            font-family: 'Montserrat', Arial, sans-serif;
            font-size: 2.3rem;
            font-weight: 700;
            letter-spacing: 2px;
            margin-bottom: 1.5rem;
            color: #fff;
            text-shadow: 0 2px 16px #0008;
        }
        form[method="get"] label, form[method="get"] select {
            color: #fff;
            font-size: 1.1rem;
        }
        form[method="get"] select {
            background: #232526;
            color: #fff;
            border: 1.5px solid #333;
            border-radius: 2em;
            padding: 0.5rem 1.2rem;
            font-size: 1.1rem;
            outline: none;
            margin-left: 0.7rem;
        }
        form[method="get"] select:focus {
            border: 1.5px solid #e50914;
        }
        #map { height: 600px; width: 100%; margin-top:1rem; border-radius: 1.2em; box-shadow: 0 4px 24px #bb86fc22; }
        .footer-bar {
            width: 100vw;
            background: rgba(18,18,18,0.98);
            color: #fff;
            font-family: 'Montserrat', Arial, sans-serif;
            text-align: center;
            padding: 1.2em 0 1.2em 0;
            font-size: 1.05rem;
            border-top: 1.5px solid #232323;
            box-shadow: 0 -2px 16px #bb86fc22;
            letter-spacing: 0.2px;
            margin-top: 2.5em;
        }
        .footer-bar a {
            color: #bb86fc;
            text-decoration: none;
            font-weight: 700;
            margin: 0 0.7em;
            border-radius: 0.7em;
            padding: 0.2em 0.7em;
            transition: background 0.2s, color 0.2s;
        }
        .footer-bar a:hover {
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            box-shadow: 0 1px 4px #bb86fc33;
        }
        .rightbar {
            min-width: 220px;
            max-width: 270px;
            padding: 2rem 1.2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
        }
        @media (max-width: 900px) {
            .container { flex-direction: column; gap: 1rem; }
            .sidebar, .rightbar { width: 100%; min-width: 0; max-width: 100%; }
            .main-content { padding: 1rem; }
        }
        @media (max-width: 600px) {
            .container { flex-direction: column; gap: 0.5rem; padding: 0.5rem; }
            .sidebar, .rightbar, .main-content { padding: 1rem; }
        }
    </style>
</head>
<body>
<div class="container">
    <!-- Sidebar gauche -->
    <aside class="sidebar">
        <h2><span class="material-icons" style="color:#bb86fc;margin-right:8px;">theaters</span>NOUVEL ACTE</h2>
        <nav>
            <ul>
                <li><a href="client.php"><span class="material-icons" style="margin-right:8px;">home</span>Accueil</a></li>
                <li><a href="agenda_culturel.php"><span class="material-icons" style="margin-right:8px;">event</span>Agenda culturel</a></li>
                <li><a href="favoris.php"><span class="material-icons" style="margin-right:8px;">star</span>Favoris</a></li>
                <li><a href="mes_reservations.php"><span class="material-icons" style="margin-right:8px;">confirmation_number</span>Mes réservations</a></li>
                <li><a href="genres_client.php"><span class="material-icons" style="margin-right:8px;">category</span>Genres</a></li>
                <li><a href="partenaire_client.php"><span class="material-icons" style="margin-right:8px;">business_center</span>Partenaires</a></li>
                <li style="margin-top:2rem;"><b>Sociale</b></li>
                <li><a href="amis.php"><span class="material-icons" style="margin-right:8px;">group</span>Amis</a></li>
                <li><a href="groupes.php"><span class="material-icons" style="margin-right:8px;">groups</span>Groupe</a></li>
                <li style="margin-top:2rem;"><b>Général</b></li>
                <li><a href="abonnement.php"><span class="material-icons" style="margin-right:8px;">card_membership</span>Abonnement</a></li>
                <li><a href="client_logout.php"><span class="material-icons" style="margin-right:8px;">logout</span>Se déconnecter</a></li>
                <li><a href="map.php" class="active"><span class="material-icons" style="margin-right:8px;">map</span>Carte des spectacles</a></li>
            </ul>
        </nav>
    </aside>
    <!-- Contenu principal -->
    <main class="main-content">
        <h1>Carte des spectacles</h1>
        <div class="card">
            <form method="get" style="margin-bottom:1.5rem;">
                <label for="ville">Filtrer par ville :</label>
                <select name="ville" id="ville" onchange="this.form.submit()">
                    <option value="">Toutes les villes</option>
                    <?php while ($v = $villes->fetch_assoc()): ?>
                        <option value="<?= htmlspecialchars($v['ville']) ?>" <?= $selected_ville == $v['ville'] ? 'selected' : '' ?>><?= htmlspecialchars($v['ville']) ?></option>
                    <?php endwhile; ?>
                </select>
            </form>
            <div id="map"></div>
            <script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
            <script>
            const representations = <?= json_encode($data) ?>;
            if (representations.length > 0) {
                const map = L.map('map').setView([
                    representations[0].latitude, representations[0].longitude
                ], 7);
                L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                    attribution: '© OpenStreetMap'
                }).addTo(map);
                representations.forEach(r => {
                    if (r.latitude && r.longitude) {
                        L.marker([r.latitude, r.longitude]).addTo(map)
                            .bindPopup(`<b>${r.titre}</b><br>${r.salle} - ${r.ville}<br>${r.date} ${r.heure}`);
                    }
                });
            }
            </script>
        </div>
    </main>
    <!-- Sidebar droite -->
<aside class="rightbar">
        <?php include 'rightbar_favoris_amis.php'; ?>
    </aside>
</div>
<footer class="footer-bar">
    <a href="confidentialite.php">Politiques de confidentialité</a> · <a href="mentions_legales.php">Mentions légales</a>
</footer>
</body>
</html> 