<?php
require_once 'db.php';
// NOTE : La colonne places_restantes est gérée automatiquement lors des réservations et annulations dans reservations.php
// Elle doit toujours refléter le nombre de places disponibles pour chaque représentation.

// Récupérer toutes les villes distinctes
$villes = $conn->query("SELECT DISTINCT ville FROM salles ORDER BY ville");
$selected_ville = isset($_GET['ville']) ? $conn->real_escape_string($_GET['ville']) : '';

// Ajout d'une représentation
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add') {
    $spectacle_id = (int)$_POST['spectacle_id'];
    $salle_id = (int)$_POST['salle_id'];
    $date = $conn->real_escape_string($_POST['date']);
    $heure = $conn->real_escape_string($_POST['heure']);
    $places_total = (int)$_POST['places_total'];
    $conn->query("INSERT INTO representations (spectacle_id, salle_id, date, heure, places_total, places_restantes) VALUES ($spectacle_id, $salle_id, '$date', '$heure', $places_total, $places_total)");
    header('Location: representations.php');
    exit();
}
// Suppression d'une représentation
if (isset($_POST['action']) && $_POST['action'] === 'delete' && isset($_POST['id'])) {
    $id = (int)$_POST['id'];
    $conn->query("DELETE FROM representations WHERE id=$id");
    header('Location: representations.php');
    exit();
}
// Liste des spectacles pour le formulaire
$spectacles = $conn->query("SELECT id, titre FROM spectacles ORDER BY titre");
// Liste des salles filtrées par ville
if ($selected_ville) {
    $salles = $conn->query("SELECT id, nom FROM salles WHERE ville = '$selected_ville' ORDER BY nom");
} else {
    $salles = $conn->query("SELECT id, nom FROM salles ORDER BY nom");
}
// Liste des représentations
$representations = $conn->query("
    SELECT r.*, s.titre AS spectacle, sa.nom AS salle, sa.ville
    FROM representations r
    JOIN spectacles s ON r.spectacle_id = s.id
    JOIN salles sa ON r.salle_id = sa.id
    " . ($selected_ville ? "WHERE sa.ville = '$selected_ville'" : "") . "
    ORDER BY r.date DESC, r.heure DESC
");
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Gestion des Représentations</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div class="container">
    <?php include 'admin_sidebar.php'; ?>
    <main class="main-content">
        <h1>Gestion des Représentations</h1>
        <form method="get" style="margin-bottom:1.5rem;">
            <label for="ville">Filtrer par ville :</label>
            <select name="ville" id="ville" onchange="this.form.submit()">
                <option value="">Toutes les villes</option>
                <?php while ($ville = $villes->fetch_assoc()): ?>
                    <option value="<?= htmlspecialchars($ville['ville']) ?>" <?= $selected_ville == $ville['ville'] ? 'selected' : '' ?>><?= htmlspecialchars($ville['ville']) ?></option>
                <?php endwhile; ?>
            </select>
        </form>
        <div class="card">
            <h2>Ajouter une représentation</h2>
            <form method="post">
                <input type="hidden" name="action" value="add">
                <div class="form-group">
                    <label>Spectacle</label>
                    <select name="spectacle_id" required>
                        <option value="">Sélectionnez un spectacle</option>
                        <?php while ($s = $spectacles->fetch_assoc()): ?>
                            <option value="<?= $s['id'] ?>"><?= htmlspecialchars($s['titre']) ?></option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label>Salle<?= $selected_ville ? ' (ville : ' . htmlspecialchars($selected_ville) . ')' : '' ?></label>
                    <select name="salle_id" required>
                        <option value="">Sélectionnez une salle</option>
                        <?php while ($sa = $salles->fetch_assoc()): ?>
                            <option value="<?= $sa['id'] ?>"><?= htmlspecialchars($sa['nom']) ?></option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label>Date</label>
                    <input type="date" name="date" required>
                </div>
                <div class="form-group">
                    <label>Heure</label>
                    <input type="time" name="heure" required>
                </div>
                <div class="form-group">
                    <label>Nombre de places</label>
                    <input type="number" name="places_total" min="1" value="100" required>
                </div>
                <button type="submit" class="btn btn-primary">Ajouter</button>
            </form>
        </div>
        <div class="card">
            <h2>Liste des représentations<?= $selected_ville ? ' - Ville : ' . htmlspecialchars($selected_ville) : '' ?></h2>
            <table>
                <thead>
                    <tr>
                        <th>Spectacle</th>
                        <th>Salle</th>
                        <th>Ville</th>
                        <th>Date</th>
                        <th>Heure</th>
                        <th>Places totales</th>
                        <th>Places restantes</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                <?php while ($r = $representations->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($r['spectacle']) ?></td>
                        <td><?= htmlspecialchars($r['salle']) ?></td>
                        <td><?= htmlspecialchars($r['ville']) ?></td>
                        <td><?= htmlspecialchars($r['date']) ?></td>
                        <td><?= htmlspecialchars($r['heure']) ?></td>
                        <td><?= htmlspecialchars($r['places_total']) ?></td>
                        <td><?= htmlspecialchars($r['places_restantes']) ?></td>
                        <td>
                            <form method="post" style="display:inline;" onsubmit="return confirm('Supprimer cette représentation ?');">
                                <input type="hidden" name="action" value="delete">
                                <input type="hidden" name="id" value="<?= $r['id'] ?>">
                                <button type="submit" class="btn btn-danger">Supprimer</button>
                            </form>
                        </td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
        <!-- Carte des représentations -->
        <div class="card">
            <h2>Carte des représentations<?= $selected_ville ? ' - Ville : ' . htmlspecialchars($selected_ville) : '' ?></h2>
            <div id="map" style="height:400px;width:100%;margin-top:1rem;"></div>
        </div>
        <link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
        <script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
        <script>
        const representations = [
            <?php
            // On refait la requête pour récupérer les coordonnées
            $sql = "SELECT r.id, s.titre AS spectacle, sa.nom AS salle, sa.ville, r.date, r.heure, sa.latitude, sa.longitude
                    FROM representations r
                    JOIN spectacles s ON r.spectacle_id = s.id
                    JOIN salles sa ON r.salle_id = sa.id
                    WHERE sa.latitude IS NOT NULL AND sa.longitude IS NOT NULL ";
            if ($selected_ville) $sql .= " AND sa.ville = '" . $conn->real_escape_string($selected_ville) . "'";
            $sql .= " ORDER BY r.date DESC, r.heure DESC";
            $resamap = $conn->query($sql);
            $first = true;
            while ($row = $resamap->fetch_assoc()):
                if (!$first) echo ",\n"; $first = false;
                echo json_encode($row);
            endwhile;
            ?>
        ];
        if (representations.length > 0) {
            const map = L.map('map').setView([
                representations[0].latitude, representations[0].longitude
            ], 7);
            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                attribution: '© OpenStreetMap'
            }).addTo(map);
            representations.forEach(r => {
                if (r.latitude && r.longitude) {
                    const popup = `<b>${r.spectacle}</b><br>${r.salle} (${r.ville})<br>${r.date} ${r.heure}`;
                    L.marker([r.latitude, r.longitude], {
                        icon: L.icon({
                            iconUrl: 'https://cdn.jsdelivr.net/npm/leaflet@1.7.1/dist/images/marker-icon.png',
                            iconSize: [25, 41],
                            iconAnchor: [12, 41],
                            popupAnchor: [1, -34],
                        })
                    }).addTo(map).bindPopup(popup);
                }
            });
        }
        </script>
    </main>
</div>
</body>
</html> 