<?php
require_once 'db.php';
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: client_login.php');
    exit();
}
// Récupérer le terme de recherche
$search = isset($_GET['q']) ? trim($_GET['q']) : '';
$spectacles = null;
if ($search !== '') {
    $search_sql = $conn->real_escape_string($search);
    $spectacles = $conn->query("SELECT * FROM spectacles WHERE titre LIKE '%$search_sql%' ORDER BY date DESC");
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Résultats de recherche</title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <style>
        body {
            min-height: 100vh;
            margin: 0;
            background: linear-gradient(135deg, #121212 0%, #1b1b1b 100%);
            font-family: 'Montserrat', Arial, sans-serif;
            color: #fff;
        }
        .container {
            display: flex;
            min-height: 100vh;
            gap: 2rem;
            padding: 2rem 1rem;
        }
        .sidebar, .rightbar {
            min-width: 220px;
            max-width: 270px;
            padding: 2rem 1.2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
            background: rgba(255,255,255,0.13);
            border: 1px solid rgba(255,255,255,0.18);
            border-radius: 1.5em;
            box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
        }
        .sidebar h2 {
            font-family: 'Montserrat', Arial, sans-serif;
            font-size: 1.4rem;
            font-weight: 700;
            letter-spacing: 2px;
            margin-bottom: 2rem;
            color: #fff;
            text-transform: uppercase;
        }
        .sidebar nav ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .sidebar nav ul li {
            margin-bottom: 1rem;
        }
        .sidebar nav ul li a {
            display: flex;
            align-items: center;
            gap: 0.7rem;
            color: #fff;
            text-decoration: none;
            font-size: 1.08rem;
            font-weight: 600;
            padding: 0.6rem 1.2rem;
            border-radius: 1em;
            background: rgba(255,255,255,0.10);
            border: 1px solid rgba(255,255,255,0.18);
            transition: transform 0.3s, background 0.3s, box-shadow 0.3s, color 0.3s;
        }
        .sidebar nav ul li a.active, .sidebar nav ul li a:hover {
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            box-shadow: 0 1px 4px #bb86fc33;
            transition: background 0.45s, color 0.45s, box-shadow 0.45s;
        }
        .main-content {
            flex: 1;
            padding: 2rem 2rem 2rem 2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
        }
        .main-content h1 {
            font-family: 'Montserrat', Arial, sans-serif;
            font-size: 2.3rem;
            font-weight: 700;
            letter-spacing: 2px;
            margin-bottom: 1.5rem;
            color: #fff;
            text-shadow: 0 2px 16px #0008;
        }
        .search-bar {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 0.7rem 1.5rem;
            margin-bottom: 1.5rem;
            border-radius: 2em;
            border: 1px solid rgba(255,255,255,0.18);
            background: rgba(255,255,255,0.10);
            box-shadow: 0 2px 12px #0002;
            transition: box-shadow 0.3s;
        }
        .search-bar input[type="text"] {
            background: transparent;
            border: none;
            color: #fff;
            font-size: 1.1rem;
            flex: 1;
            outline: none;
            padding: 0.5rem 0.5rem;
        }
        .search-bar .material-icons {
            color: #bb86fc;
            font-size: 1.3rem;
        }
        .card {
            background: rgba(255,255,255,0.13);
            border: 1px solid rgba(255,255,255,0.18);
            border-radius: 1.5em;
            box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
            padding: 2rem 2rem 1.5rem 2rem;
            margin-bottom: 2rem;
        }
        .spectacles-list {
            display: flex;
            flex-wrap: wrap;
            gap: 2rem;
        }
        .spectacle-card {
            min-width: 120px;
            max-width: 180px;
            display: flex;
            flex-direction: column;
            align-items: center;
            border: 1px solid rgba(255,255,255,0.18);
            background: rgba(255,255,255,0.13);
            box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
            border-radius: 1.5em;
            padding: 1.2rem 1rem 1.2rem 1rem;
            transition: transform 0.3s, box-shadow 0.3s;
            will-change: transform;
            cursor: pointer;
        }
        .spectacle-card:hover {
            transform: scale(1.05);
            box-shadow: 0 16px 48px 0 #03dac655;
        }
        .spectacle-img {
            width: 100px;
            height: 140px;
            background: #bdbdbd;
            border-radius: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 0 auto;
            position: relative;
            overflow: hidden;
        }
        .spectacle-img img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 24px;
            display: block;
        }
        .spectacle-title {
            color: #fff;
            font-size: 1rem;
            font-weight: bold;
            margin-top: 0.4rem;
            margin-bottom: 0.1rem;
            text-align: center;
            width: 100%;
        }
        .spectacle-date {
            color: #FFD600;
            font-size: 0.95rem;
            margin-bottom: 0.2rem;
        }
        .footer-bar {
            width: 100vw;
            background: rgba(18,18,18,0.98);
            color: #fff;
            font-family: 'Montserrat', Arial, sans-serif;
            text-align: center;
            padding: 1.2em 0 1.2em 0;
            font-size: 1.05rem;
            border-top: 1.5px solid #232323;
            box-shadow: 0 -2px 16px #bb86fc22;
            letter-spacing: 0.2px;
            margin-top: 2.5em;
        }
        .footer-bar a {
            color: #bb86fc;
            text-decoration: none;
            font-weight: 700;
            margin: 0 0.7em;
            border-radius: 0.7em;
            padding: 0.2em 0.7em;
            transition: background 0.2s, color 0.2s;
        }
        .footer-bar a:hover {
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            box-shadow: 0 1px 4px #bb86fc33;
        }
        .rightbar {
            min-width: 220px;
            max-width: 270px;
            padding: 2rem 1.2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
            background: rgba(255,255,255,0.13);
            border: 1px solid rgba(255,255,255,0.18);
            border-radius: 1.5em;
            box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
        }
        @media (max-width: 900px) {
            .container { flex-direction: column; gap: 1rem; }
            .sidebar, .rightbar { width: 100%; min-width: 0; max-width: 100%; }
            .main-content { padding: 1rem; }
        }
        @media (max-width: 600px) {
            .container { flex-direction: column; gap: 0.5rem; padding: 0.5rem; }
            .sidebar, .rightbar, .main-content { padding: 1rem; }
        }
    </style>
</head>
<body>
<div class="container">
    <!-- Sidebar gauche -->
    <aside class="sidebar">
        <h2><span class="material-icons" style="color:#bb86fc;margin-right:8px;">theaters</span>NOUVEL ACTE</h2>
        <nav>
            <ul>
                <li><a href="client.php"><span class="material-icons" style="margin-right:8px;">home</span>Accueil</a></li>
                <li><a href="agenda_culturel.php"><span class="material-icons" style="margin-right:8px;">event</span>Agenda culturel</a></li>
                <li><a href="favoris.php"><span class="material-icons" style="margin-right:8px;">star</span>Favoris</a></li>
                <li><a href="mes_reservations.php"><span class="material-icons" style="margin-right:8px;">confirmation_number</span>Mes réservations</a></li>
                <li><a href="genres_client.php"><span class="material-icons" style="margin-right:8px;">category</span>Genres</a></li>
                <li><a href="partenaire_client.php"><span class="material-icons" style="margin-right:8px;">business_center</span>Partenaires</a></li>
                <li style="margin-top:2rem;"><b>Sociale</b></li>
                <li><a href="amis.php"><span class="material-icons" style="margin-right:8px;">group</span>Amis</a></li>
                <li><a href="groupes.php"><span class="material-icons" style="margin-right:8px;">groups</span>Groupe</a></li>
                <li style="margin-top:2rem;"><b>Général</b></li>
                <li><a href="abonnement.php"><span class="material-icons" style="margin-right:8px;">card_membership</span>Abonnement</a></li>
                <li><a href="client_logout.php"><span class="material-icons" style="margin-right:8px;">logout</span>Se déconnecter</a></li>
                <li><a href="map.php"><span class="material-icons" style="margin-right:8px;">map</span>Carte des spectacles</a></li>
            </ul>
        </nav>
    </aside>
    <!-- Contenu principal -->
    <main class="main-content">
        <form class="search-bar" method="get" action="resultats_recherche.php">
            <span class="material-icons search-icon">search</span>
            <input type="text" name="q" placeholder="Rechercher" value="<?= htmlspecialchars($search) ?>">
        </form>
        <div class="card">
            <h1>Résultats de recherche</h1>
            <div class="spectacles-list">
                <?php if ($search === ''): ?>
                    <div style="color:#888;">Aucun terme de recherche fourni.</div>
                <?php elseif ($spectacles && $spectacles->num_rows > 0): ?>
                    <?php while ($s = $spectacles->fetch_assoc()): ?>
                        <div class="spectacle-card" onclick="window.location.href='spectacle.php?id=<?= $s['id'] ?>'">
                            <div class="spectacle-img">
                                <?php if ($s['image']): ?>
                                    <img src="uploads/<?= htmlspecialchars($s['image']) ?>" alt="Affiche">
                                <?php else: ?>
                                    <span class="material-icons" style="font-size:40px;color:#888;">image</span>
                                <?php endif; ?>
                            </div>
                            <div class="spectacle-title"><?= htmlspecialchars($s['titre']) ?></div>
                            <div class="spectacle-date">
                                <?php if (!empty($s['date'])): ?>
                                    <?= date('d/m/Y', strtotime($s['date'])) ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endwhile; ?>
                <?php else: ?>
                    <div style="color:#888;">Aucun spectacle trouvé pour "<?= htmlspecialchars($search) ?>".</div>
                <?php endif; ?>
            </div>
        </div>
    </main>
    <!-- Sidebar droite -->
    <aside class="rightbar">
        <?php include 'rightbar_favoris_amis.php'; ?>
    </aside>
</div>
<footer class="footer-bar">
    <a href="confidentialite.php">Politiques de confidentialité</a> · <a href="mentions_legales.php">Mentions légales</a>
</footer>
</body>
</html> 