<?php
require_once 'db.php';
// Ajout d'une salle
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add') {
    $nom = $conn->real_escape_string($_POST['nom']);
    $ville = $conn->real_escape_string($_POST['ville']);
    $capacite = (int)$_POST['capacite'];
    $latitude = !empty($_POST['latitude']) ? floatval($_POST['latitude']) : null;
    $longitude = !empty($_POST['longitude']) ? floatval($_POST['longitude']) : null;
    // Si latitude/longitude non fournis, on tente de géocoder la ville
    if ($latitude === null || $longitude === null) {
        $url = "https://nominatim.openstreetmap.org/search?city=" . urlencode($ville) . "&country=France&format=json&limit=1";
        $opts = ['http' => ['header' => "User-Agent: stp-reservation/1.0\r\n"]];
        $context = stream_context_create($opts);
        $json = @file_get_contents($url, false, $context);
        if ($json) {
            $data = json_decode($json, true);
            if (!empty($data[0])) {
                $latitude = $data[0]['lat'];
                $longitude = $data[0]['lon'];
            }
        }
    }
    $conn->query("INSERT INTO salles (nom, ville, capacite, latitude, longitude) VALUES ('$nom', '$ville', $capacite, " . ($latitude !== null ? $latitude : 'NULL') . ", " . ($longitude !== null ? $longitude : 'NULL') . ")");
    header('Location: salles.php');
    exit();
}
// Suppression d'une salle
if (isset($_POST['action']) && $_POST['action'] === 'delete' && isset($_POST['id'])) {
    $id = (int)$_POST['id'];
    $conn->query("DELETE FROM salles WHERE id=$id");
    header('Location: salles.php');
    exit();
}
// Liste des salles
$salles = $conn->query("SELECT * FROM salles ORDER BY nom");
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Gestion des Salles</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div class="container">
    <?php include 'admin_sidebar.php'; ?>
    <main class="main-content">
        <h1>Gestion des Salles</h1>
        <div class="card">
            <h2>Ajouter une salle</h2>
            <form method="post">
                <input type="hidden" name="action" value="add">
                <div class="form-group">
                    <label>Nom</label>
                    <input type="text" name="nom" required>
                </div>
                <div class="form-group">
                    <label>Ville</label>
                    <input type="text" name="ville" required>
                </div>
                <div class="form-group">
                    <label>Capacité</label>
                    <input type="number" name="capacite" min="1" required>
                </div>
                <div class="form-group">
                    <label>Latitude</label>
                    <input type="text" name="latitude" placeholder="Ex: 48.8583701">
                </div>
                <div class="form-group">
                    <label>Longitude</label>
                    <input type="text" name="longitude" placeholder="Ex: 2.2944813">
                </div>
                <button type="submit" class="btn btn-primary">Ajouter</button>
            </form>
        </div>
        <div class="card">
            <h2>Liste des salles</h2>
            <table>
                <thead>
                    <tr>
                        <th>Nom</th>
                        <th>Ville</th>
                        <th>Capacité</th>
                        <th>Latitude</th>
                        <th>Longitude</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                <?php while ($s = $salles->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($s['nom']) ?></td>
                        <td><?= htmlspecialchars($s['ville']) ?></td>
                        <td><?= htmlspecialchars($s['capacite']) ?></td>
                        <td><?= htmlspecialchars($s['latitude']) ?></td>
                        <td><?= htmlspecialchars($s['longitude']) ?></td>
                        <td>
                            <form method="post" style="display:inline;" onsubmit="return confirm('Supprimer cette salle ?');">
                                <input type="hidden" name="action" value="delete">
                                <input type="hidden" name="id" value="<?= $s['id'] ?>">
                                <button type="submit" class="btn btn-danger">Supprimer</button>
                            </form>
                        </td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </main>
</div>
</body>
</html> 