<?php
require_once 'db.php';
// Récupérer les genres pour le formulaire
$genres = $conn->query("SELECT * FROM genres ORDER BY nom");
// Ajout d'un spectacle
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add') {
    $titre = $conn->real_escape_string($_POST['titre']);
    $description = $conn->real_escape_string($_POST['description']);
    $date = $conn->real_escape_string($_POST['date']);
    $duree = (int)$_POST['duree'];
    $genre_id = (int)$_POST['genre_id'];
    // Vérifier que le genre existe
    if (!$genre_id || !$conn->query("SELECT id FROM genres WHERE id = $genre_id")->fetch_assoc()) {
        die("Erreur : le genre sélectionné n'existe pas.");
    }
    $image = null;
    // Vérifier/créer le dossier uploads
    if (!is_dir('uploads')) { mkdir('uploads', 0777, true); }
    if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
        $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
        $image = uniqid('affiche_', true) . '.' . $ext;
        move_uploaded_file($_FILES['image']['tmp_name'], 'uploads/' . $image);
    }
    $image_sql = $image ? "'$image'" : 'NULL';
    $conn->query("INSERT INTO spectacles (titre, description, date, duree, image, genre_id) VALUES ('$titre', '$description', '$date', $duree, $image_sql, $genre_id)");
    header('Location: spectacles.php');
    exit();
}
// Suppression d'un spectacle
if (isset($_POST['action']) && $_POST['action'] === 'delete' && isset($_POST['id'])) {
    $id = (int)$_POST['id'];
    // Supprimer l'image associée si elle existe
    $img = $conn->query("SELECT image FROM spectacles WHERE id=$id")->fetch_assoc();
    if ($img && $img['image'] && file_exists('uploads/' . $img['image'])) {
        unlink('uploads/' . $img['image']);
    }
    $conn->query("DELETE FROM spectacles WHERE id=$id");
    header('Location: spectacles.php');
    exit();
}
// Liste des spectacles
$spectacles = $conn->query("SELECT * FROM spectacles ORDER BY date");
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Gestion des Spectacles</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .affiche-img { max-width: 80px; max-height: 100px; border-radius: 6px; }
    </style>
</head>
<body>
<div class="container">
    <?php include 'admin_sidebar.php'; ?>
    <main class="main-content">
        <h1>Gestion des Spectacles</h1>
        <div class="card">
            <h2>Ajouter un spectacle</h2>
            <form method="post" enctype="multipart/form-data">
                <input type="hidden" name="action" value="add">
                <div class="form-group">
                    <label>Titre</label>
                    <input type="text" name="titre" required>
                </div>
                <div class="form-group">
                    <label>Description</label>
                    <textarea name="description" required></textarea>
                </div>
                <div class="form-group">
                    <label>Date</label>
                    <input type="date" name="date" required>
                </div>
                <div class="form-group">
                    <label>Durée (minutes)</label>
                    <input type="number" name="duree" min="1" required>
                </div>
                <div class="form-group">
                    <label>Genre</label>
                    <select name="genre_id" required>
                        <option value="">Sélectionnez un genre</option>
                        <?php while ($g = $genres->fetch_assoc()): ?>
                            <option value="<?= $g['id'] ?>"><?= htmlspecialchars($g['nom']) ?></option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label>Affiche (image)</label>
                    <input type="file" name="image" accept="image/*">
                </div>
                <button type="submit" class="btn btn-primary">Ajouter</button>
            </form>
        </div>
        <div class="card">
            <h2>Liste des spectacles</h2>
            <table>
                <thead>
                    <tr>
                        <th>Affiche</th>
                        <th>Titre</th>
                        <th>Description</th>
                        <th>Date</th>
                        <th>Durée</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                <?php while ($s = $spectacles->fetch_assoc()): ?>
                    <tr>
                        <td>
                            <?php if ($s['image']): ?>
                                <img src="uploads/<?= htmlspecialchars($s['image']) ?>" alt="Affiche" class="affiche-img">
                            <?php else: ?>
                                <span style="color:#aaa;">Aucune</span>
                            <?php endif; ?>
                        </td>
                        <td><?= htmlspecialchars($s['titre']) ?></td>
                        <td><?= htmlspecialchars($s['description']) ?></td>
                        <td><?= htmlspecialchars($s['date']) ?></td>
                        <td><?= htmlspecialchars($s['duree']) ?> min</td>
                        <td>
                            <form method="post" style="display:inline;" onsubmit="return confirm('Supprimer ce spectacle ?');">
                                <input type="hidden" name="action" value="delete">
                                <input type="hidden" name="id" value="<?= $s['id'] ?>">
                                <button type="submit" class="btn btn-danger">Supprimer</button>
                            </form>
                        </td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </main>
</div>
</body>
</html> 