<?php
session_start();
require_once 'config/database.php';

// Vérifier si l'utilisateur est connecté
if (!isset($_SESSION['user_id'])) {
  header('Location: identification.php');
  exit();
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Nouvel Acte - À Venir</title>
  <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
  <div class="container">
      <!-- Sidebar -->
      <?php include 'includes/sidebar.php'; ?>

      <!-- Header -->
      <header class="header">
          <div class="search-box">
              <!-- Le header peut rester simple pour cette page ou inclure une recherche si nécessaire -->
              <h1>Ma Liste "À Venir"</h1>
          </div>
          <div class="actions">
              <div class="icon-btn notification-btn" title="Notifications"></div>
          </div>
      </header>

      <!-- Contenu principal -->
      <main class="main">
          <section class="watchlist-grid">
              <div class="cards cards-watchlist" id="watchlistCardsContainer">
                  <!-- Les cartes seront chargées ici par JavaScript -->
                  <p class="loading-message">Chargement de votre liste "À venir"...</p>
              </div>
          </section>
      </main>

      <!-- Sidebar droite (optionnelle pour cette page, peut être enlevée ou adaptée) -->
      <aside class="aside">
          <div class="profile">
              <img src="assets/images/avatar-placeholder.jpg" alt="Avatar"/>
              <div class="info">
                  <div><?php echo htmlspecialchars($_SESSION['user_name']); ?></div>
                  <div>@<?php echo strtolower(str_replace(' ', '', $_SESSION['user_name'])); ?></div>
              </div>
          </div>
          <!-- Autres contenus de la sidebar droite si pertinents -->
      </aside>
  </div>

  <script src="assets/js/watchlist.js"></script>
  <script src="assets/js/main.js"></script> <!-- Pour showNotification si elle est globale -->
</body>
</html>
