# 📁 Structure correcte pour cPanel

## Structure de fichiers requise

Votre dossier `SAE202_danslebon` doit avoir cette structure :

\`\`\`
SAE202_danslebon/
├── public/
│   ├── index.php          ← Point d'entrée principal
│   └── .htaccess          ← Configuration Apache
├── app/
│   ├── Controllers/       ← Contrôleurs (non accessibles directement)
│   ├── Models/           ← Modèles
│   ├── Views/            ← Vues
│   └── Core/             ← Classes du framework
├── config/
│   ├── database.php      ← Configuration BDD
│   └── cpanel_bootstrap.php
├── storage/
│   └── logs/             ← Logs d'erreur
├── database/
│   └── schema.sql        ← Structure de la base
├── test_connection.php   ← Test de connexion
└── debug.php            ← Fichier de débogage
\`\`\`

## URLs correctes

❌ **INCORRECT** : 
- https://ilan.molia.mmi-velizy.fr/SAE202_danslebon/app/Controllers/...

✅ **CORRECT** :
- https://ilan.molia.mmi-velizy.fr/SAE202_danslebon/public/
- https://ilan.molia.mmi-velizy.fr/SAE202_danslebon/public/admin
- https://ilan.molia.mmi-velizy.fr/SAE202_danslebon/public/login

## Étapes de correction

1. **Vérifiez la structure** avec debug.php
2. **Testez la connexion** avec test_connection.php  
3. **Accédez via public/** uniquement
4. **Importez le schéma SQL** dans phpMyAdmin
