# Nouvel Acte - Système de Réservation de Spectacles

## Description

Application web complète pour la réservation de spectacles avec :
- Front-office public pour les spectateurs
- Back-office sécurisé pour les administrateurs
- API REST interne
- Gestion complète des réservations, avis, utilisateurs

## Technologies

- **Backend** : PHP 8.3+ avec architecture MVC
- **Base de données** : MySQL 8.0
- **Frontend** : HTML5, CSS3, JavaScript vanilla
- **Conteneurisation** : Docker & Docker Compose
- **Sécurité** : Authentification sécurisée, protection CSRF, validation des données

## Installation

### Prérequis
- Docker et Docker Compose
- Git

### Étapes d'installation

1. **Cloner le projet**
\`\`\`bash
git clone <repository-url>
cd nouvel-acte
\`\`\`

2. **Configuration de l'environnement**
\`\`\`bash
cp .env.example .env
# Éditer .env avec vos paramètres
\`\`\`

3. **Lancement avec Docker**
\`\`\`bash
docker-compose up -d
\`\`\`

4. **Accès à l'application**
- Application : http://localhost:8000
- PhpMyAdmin : http://localhost:8080
- Admin par défaut : admin@nouvelacte.fr / (voir base de données)

## Structure du projet

\`\`\`
nouvel-acte/
├── app/
│   ├── Controllers/        # Contrôleurs MVC
│   │   ├── Admin/         # Contrôleurs back-office
│   │   └── API/           # Contrôleurs API REST
│   ├── Models/            # Modèles de données
│   ├── Views/             # Templates et vues
│   ├── Core/              # Classes du framework
│   └── Middleware/        # Middlewares d'authentification
├── config/                # Configuration de l'application
├── database/              # Schémas et migrations
├── public/                # Point d'entrée web
├── storage/               # Fichiers uploadés, logs
├── tests/                 # Tests unitaires et d'intégration
└── docker/                # Configuration Docker
\`\`\`

## Fonctionnalités principales

### Front-office
- ✅ Inscription/Connexion utilisateur
- ✅ Navigation par catégories et recherche
- ✅ Fiche spectacle avec réservation
- ✅ Système d'avis et notation
- ✅ Gestion des favoris
- ✅ Fonctionnalités sociales (amis, groupes)

### Back-office
- ✅ Dashboard avec statistiques temps réel
- ✅ Gestion complète des spectacles (CRUD)
- ✅ Planning et séances
- ✅ Configuration des salles et plans de sièges
- ✅ Gestion des réservations et remboursements
- ✅ Modération des avis
- ✅ Gestion des utilisateurs et rôles
- ✅ Statistiques et exports

### Sécurité
- ✅ Authentification sécurisée (Argon2ID)
- ✅ Protection CSRF
- ✅ Validation et sanitisation des données
- ✅ Logs d'audit complets
- ✅ Gestion des rôles et permissions

## API REST

### Endpoints principaux

\`\`\`
GET    /api/performances           # Liste des spectacles
GET    /api/performances/{id}      # Détail d'un spectacle
POST   /api/reservations          # Créer une réservation
GET    /api/schedules/{id}/seats   # Places disponibles
POST   /api/reviews               # Ajouter un avis
GET    /api/user/favorites        # Favoris de l'utilisateur
\`\`\`

## Base de données

### Tables principales
- `users` : Utilisateurs et authentification
- `performances` : Spectacles et métadonnées
- `schedules` : Séances et horaires
- `reservations` : Réservations et paiements
- `reviews` : Avis et modération
- `halls` : Salles et configuration des sièges

## Tests

\`\`\`bash
# Tests unitaires
composer test

# Analyse statique
composer analyse

# Tests d'intégration
docker-compose exec app php vendor/bin/phpunit --testsuite=Integration
\`\`\`

## Déploiement

### Production
1. Configurer les variables d'environnement
2. Optimiser l'autoloader : `composer install --no-dev --optimize-autoloader`
3. Configurer HTTPS et certificats SSL
4. Mettre en place les sauvegardes automatiques
5. Configurer la surveillance et les logs

### CI/CD avec GitHub Actions
\`\`\`yaml
# .github/workflows/deploy.yml
name: Deploy
on:
  push:
    branches: [main]
jobs:
  deploy:
    runs-on: ubuntu-latest
    steps:
      - uses: actions/checkout@v3
      - name: Deploy to production
        run: |
          # Scripts de déploiement
\`\`\`

## Monitoring et maintenance

- **Logs** : Centralisés dans `/storage/logs/`
- **Métriques** : Dashboard admin avec KPIs
- **Sauvegardes** : Automatiques quotidiennes
- **Monitoring** : Surveillance des performances et erreurs

## Support et documentation

- **Documentation technique** : `/docs/`
- **Guide utilisateur** : Interface admin intégrée
- **API Documentation** : Swagger/OpenAPI disponible
- **Support** : Issues GitHub ou contact admin

## Licence

Propriétaire - Nouvel Acte © 2024
