<?php
declare(strict_types=1);

namespace App\Models;

use App\Core\Database;
use PDO;

class User
{
    private PDO $db;
    
    public function __construct()
    {
        $this->db = Database::getInstance();
    }
    
    public function findByEmail(string $email): ?array
    {
        $stmt = $this->db->prepare('
            SELECT u.*, r.name as role_name 
            FROM users u 
            JOIN roles r ON u.role_id = r.id 
            WHERE u.email = ?
        ');
        $stmt->execute([$email]);
        
        $user = $stmt->fetch();
        return $user ?: null;
    }
    
    public function findById(int $id): ?array
    {
        $stmt = $this->db->prepare('
            SELECT u.*, r.name as role_name 
            FROM users u 
            JOIN roles r ON u.role_id = r.id 
            WHERE u.id = ?
        ');
        $stmt->execute([$id]);
        
        $user = $stmt->fetch();
        return $user ?: null;
    }
    
    public function create(array $data): int
    {
        $stmt = $this->db->prepare('
            INSERT INTO users (email, password_hash, display_name, role_id, created_at) 
            VALUES (?, ?, ?, ?, NOW())
        ');
        
        $stmt->execute([
            $data['email'],
            $data['password_hash'],
            $data['display_name'],
            $data['role_id']
        ]);
        
        return (int) $this->db->lastInsertId();
    }
    
    public function getAll(int $limit = 50, int $offset = 0): array
    {
        $stmt = $this->db->prepare('
            SELECT u.*, r.name as role_name 
            FROM users u 
            JOIN roles r ON u.role_id = r.id 
            ORDER BY u.created_at DESC 
            LIMIT ? OFFSET ?
        ');
        $stmt->execute([$limit, $offset]);
        
        return $stmt->fetchAll();
    }
}
?>
