<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($title) ? htmlspecialchars($title) : 'Admin - Nouvel Acte' ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; background: #f5f5f5; }
        
        .admin-container {
            display: grid;
            grid-template-columns: 250px 1fr;
            min-height: 100vh;
        }
        
        .admin-sidebar {
            background: #1a1a1a;
            color: white;
            padding: 2rem 1rem;
        }
        
        .admin-sidebar h2 {
            margin-bottom: 2rem;
            color: #E30B17;
        }
        
        .admin-nav ul {
            list-style: none;
        }
        
        .admin-nav li {
            margin-bottom: 0.5rem;
        }
        
        .admin-nav a {
            color: #ccc;
            text-decoration: none;
            padding: 0.75rem 1rem;
            display: block;
            border-radius: 4px;
            transition: background 0.2s;
        }
        
        .admin-nav a:hover {
            background: #333;
            color: white;
        }
        
        .admin-main {
            padding: 2rem;
        }
        
        .admin-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid #ddd;
        }
        
        .admin-header h1 {
            color: #333;
        }
        
        .btn {
            padding: 0.5rem 1rem;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
        }
        
        .btn-primary {
            background: #E30B17;
            color: white;
        }
        
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        
        .card {
            background: white;
            border-radius: 8px;
            padding: 1.5rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            margin-bottom: 1rem;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1rem;
            margin-bottom: 2rem;
        }
        
        .stat-card {
            background: white;
            padding: 1.5rem;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            text-align: center;
        }
        
        .stat-value {
            font-size: 2rem;
            font-weight: bold;
            color: #E30B17;
        }
        
        .stat-label {
            color: #666;
            margin-top: 0.5rem;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        
        th, td {
            padding: 1rem;
            text-align: left;
            border-bottom: 1px solid #eee;
        }
        
        th {
            background: #f8f9fa;
            font-weight: 600;
        }
        
        .status-badge {
            padding: 0.25rem 0.5rem;
            border-radius: 12px;
            font-size: 0.75rem;
            font-weight: 500;
        }
        
        .status-paid { background: #d4edda; color: #155724; }
        .status-pending { background: #fff3cd; color: #856404; }
        .status-cancelled { background: #f8d7da; color: #721c24; }
        
        .error-message {
            background: #f8d7da;
            color: #721c24;
            padding: 1rem;
            border-radius: 4px;
            margin: 1rem 0;
        }
    </style>
</head>
<body>
    <div class="admin-container">
        <aside class="admin-sidebar">
            <h2>Admin Panel</h2>
            <nav class="admin-nav">
                <ul>
                    <li><a href="/SAE202_danslebon/public/admin">Dashboard</a></li>
                    <li><a href="/SAE202_danslebon/public/admin/performances">Spectacles</a></li>
                    <li><a href="/SAE202_danslebon/public/admin/schedules">Planning</a></li>
                    <li><a href="/SAE202_danslebon/public/admin/halls">Salles</a></li>
                    <li><a href="/SAE202_danslebon/public/admin/reservations">Réservations</a></li>
                    <li><a href="/SAE202_danslebon/public/admin/users">Utilisateurs</a></li>
                    <li><a href="/SAE202_danslebon/public/admin/reviews">Avis</a></li>
                    <li><a href="/SAE202_danslebon/public/admin/statistics">Statistiques</a></li>
                </ul>
            </nav>
        </aside>
        
        <main class="admin-main">
            <div class="admin-header">
                <h1><?= isset($pageTitle) ? htmlspecialchars($pageTitle) : 'Dashboard' ?></h1>
                <div>
                    <?php if (isset($_SESSION['user']) && is_array($_SESSION['user'])): ?>
                        <span>Bonjour, <?= htmlspecialchars($_SESSION['user']['display_name'] ?? 'Utilisateur') ?></span>
                        <a href="/SAE202_danslebon/public/logout" class="btn btn-secondary">Déconnexion</a>
                    <?php else: ?>
                        <a href="/SAE202_danslebon/public/login" class="btn btn-primary">Connexion</a>
                    <?php endif; ?>
                </div>
            </div>
            
            <?php if (isset($content) && !empty($content)): ?>
                <?= $content ?>
            <?php else: ?>
                <div class="error-message">
                    <h3>Contenu non disponible</h3>
                    <p>Le contenu de cette page n'a pas pu être chargé.</p>
                </div>
            <?php endif; ?>
        </main>
    </div>
</body>
</html>
