<?php
// Fichier de débogage temporaire
echo "<h1>Test de débogage</h1>";
echo "<p>PHP Version: " . PHP_VERSION . "</p>";
echo "<p>Document Root: " . $_SERVER['DOCUMENT_ROOT'] . "</p>";
echo "<p>Script Name: " . $_SERVER['SCRIPT_NAME'] . "</p>";
echo "<p>Request URI: " . $_SERVER['REQUEST_URI'] . "</p>";

echo "<h2>Fichiers dans le répertoire actuel:</h2>";
$files = scandir('.');
foreach ($files as $file) {
    if ($file != '.' && $file != '..') {
        echo "<p>$file " . (is_dir($file) ? '(dossier)' : '(fichier)') . "</p>";
    }
}

echo "<h2>Test d'inclusion:</h2>";
if (file_exists('config/database.php')) {
    echo "<p>✅ config/database.php trouvé</p>";
    try {
        require_once 'config/database.php';
        echo "<p>✅ config/database.php inclus avec succès</p>";
    } catch (Exception $e) {
        echo "<p>❌ Erreur inclusion: " . $e->getMessage() . "</p>";
    }
} else {
    echo "<p>❌ config/database.php non trouvé</p>";
}

if (file_exists('config/cpanel_bootstrap.php')) {
    echo "<p>✅ config/cpanel_bootstrap.php trouvé</p>";
} else {
    echo "<p>❌ config/cpanel_bootstrap.php non trouvé</p>";
}

echo "<h2>Supprimez ce fichier après le test !</h2>";
?>
