<?php
declare(strict_types=1);

/**
 * Script d'installation pour cPanel
 * À exécuter une seule fois après upload des fichiers
 */

require_once __DIR__ . '/../config/cpanel_bootstrap.php';

echo "<!DOCTYPE html>
<html>
<head>
    <title>Installation Nouvel Acte</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 800px; margin: 50px auto; padding: 20px; }
        .success { color: green; background: #d4edda; padding: 10px; border-radius: 5px; margin: 10px 0; }
        .error { color: red; background: #f8d7da; padding: 10px; border-radius: 5px; margin: 10px 0; }
        .info { color: blue; background: #d1ecf1; padding: 10px; border-radius: 5px; margin: 10px 0; }
        pre { background: #f8f9fa; padding: 15px; border-radius: 5px; overflow-x: auto; }
    </style>
</head>
<body>";

echo "<h1>🎭 Installation Nouvel Acte</h1>";

// Vérification des prérequis
echo "<h2>1. Vérification des prérequis</h2>";

$phpVersion = PHP_VERSION;
echo "<div class='info'>Version PHP: $phpVersion</div>";

if (version_compare($phpVersion, '8.0', '<')) {
    echo "<div class='error'>❌ PHP 8.0+ requis. Version actuelle: $phpVersion</div>";
    exit;
}

$requiredExtensions = ['pdo', 'pdo_mysql', 'json', 'mbstring'];
foreach ($requiredExtensions as $ext) {
    if (extension_loaded($ext)) {
        echo "<div class='success'>✅ Extension $ext disponible</div>";
    } else {
        echo "<div class='error'>❌ Extension $ext manquante</div>";
    }
}

// Test de connexion à la base de données
echo "<h2>2. Test de connexion à la base de données</h2>";

try {
    $pdo = \App\Core\CpanelDatabase::getInstance();
    echo "<div class='success'>✅ Connexion à la base de données réussie</div>";
    
    // Vérification des tables
    echo "<h3>Vérification des tables</h3>";
    $tables = ['users', 'roles', 'performances', 'categories', 'schedules', 'reservations'];
    
    foreach ($tables as $table) {
        try {
            $stmt = $pdo->query("SHOW TABLES LIKE '$table'");
            if ($stmt->rowCount() > 0) {
                echo "<div class='success'>✅ Table $table existe</div>";
            } else {
                echo "<div class='error'>❌ Table $table manquante</div>";
            }
        } catch (Exception $e) {
            echo "<div class='error'>❌ Erreur vérification table $table: " . $e->getMessage() . "</div>";
        }
    }
    
} catch (Exception $e) {
    echo "<div class='error'>❌ Erreur de connexion: " . $e->getMessage() . "</div>";
    echo "<div class='info'>Vérifiez votre configuration dans config/database.php</div>";
}

// Vérification des permissions de fichiers
echo "<h2>3. Vérification des permissions</h2>";

$directories = [
    'storage/logs' => 'Logs d\'erreur',
    'storage/uploads' => 'Fichiers uploadés',
    'storage/cache' => 'Cache de l\'application'
];

foreach ($directories as $dir => $description) {
    $fullPath = __DIR__ . '/../' . $dir;
    
    if (!is_dir($fullPath)) {
        if (mkdir($fullPath, 0755, true)) {
            echo "<div class='success'>✅ Dossier $dir créé ($description)</div>";
        } else {
            echo "<div class='error'>❌ Impossible de créer le dossier $dir</div>";
        }
    } else {
        echo "<div class='success'>✅ Dossier $dir existe ($description)</div>";
    }
    
    if (is_writable($fullPath)) {
        echo "<div class='success'>✅ Dossier $dir accessible en écriture</div>";
    } else {
        echo "<div class='error'>❌ Dossier $dir non accessible en écriture</div>";
    }
}

// Instructions finales
echo "<h2>4. Instructions finales</h2>";

echo "<div class='info'>
<h3>Configuration terminée !</h3>
<p>Votre application Nouvel Acte est maintenant installée. Voici les étapes suivantes :</p>
<ol>
    <li><strong>Supprimez ce fichier d'installation</strong> pour des raisons de sécurité</li>
    <li>Accédez à votre site : <a href='../'>Page d'accueil</a></li>
    <li>Connectez-vous à l'admin : <a href='../admin'>Interface d'administration</a></li>
    <li>Compte admin par défaut : admin@nouvelacte.fr (voir base de données pour le mot de passe)</li>
</ol>
</div>";

echo "<h3>Configuration cPanel recommandée :</h3>";
echo "<pre>
1. Dans cPanel > Bases de données MySQL :
   - Créez une base de données
   - Créez un utilisateur
   - Assignez tous les privilèges

2. Dans cPanel > Gestionnaire de fichiers :
   - Uploadez tous les fichiers dans public_html/
   - Définissez les permissions 755 pour les dossiers
   - Définissez les permissions 644 pour les fichiers

3. Configuration SSL :
   - Activez SSL/TLS dans cPanel
   - Forcez HTTPS pour sécuriser les connexions

4. Sauvegarde :
   - Configurez des sauvegardes automatiques
   - Testez la restauration
</pre>";

echo "</body></html>";
?>
