<?php
require_once __DIR__ . '/Vaisseau.php';
require_once __DIR__ . '/Bonus.php';
require_once __DIR__ . '/Drone.php';

class Partie {
    public $idBdd;
    public $joueur1;

    public function __construct() {}

    public function nouveauMessage($texte, $auteur = 0) {
        if ($auteur === 0) $texte = $this->formaterTexteLog($texte);
        array_unshift($this->logs, ['heure' => date('H:i:s'), 'auteur' => $auteur, 'texte' => $texte]);
        if (count($this->logs) > 30) array_pop($this->logs);
    }
    private function formaterTexteLog($texte) {
        $texte = str_replace("Joueur 1", "<strong class='msg-j1'>Joueur 1</strong>", $texte);
        $texte = str_replace("Joueur 2", "<strong class='msg-j2'>Joueur 2</strong>", $texte);
        return $texte;
    }

    // --- BONUS ---
    public function verifierBonus($vaisseau) {
        $pos = $vaisseau->getPos();
        foreach ($this->bonusListe as $key => $bonus) {
            if ($bonus->x == $pos['x'] && $bonus->y == $pos['y']) {
                if ($bonus->type === 'energie') { 
                    // BONUS TERRAIN : +7
                    $vaisseau->rechargerEnergie(7); 
                    $this->nouveauMessage("⚡ Le Joueur {$vaisseau->getId()} a trouvé de l'énergie (+7).", 0); 
                }
                elseif ($bonus->type === 'personnage') { 
                    $classe = $bonus->contenu; if (class_exists($classe) && $vaisseau->ajouterMembre(new $classe())) { $this->nouveauMessage("🧑‍🚀 Recrue : $classe !", 0); } 
                }
                elseif ($bonus->type === 'drone') { 
                    $droneObj = $bonus->contenu; $vaisseau->ramasserDrone($droneObj); 
                    $this->nouveauMessage("🛸 Le Joueur {$vaisseau->getId()} a récupéré une technologie Drone.", 0); 
                }
                unset($this->bonusListe[$key]);
            }
        }
    }

    // --- LE RESTE NE CHANGE PAS ---
    public function getToursRestantsBonus() { $remaining = 10 - ($this->tour % 10); return ($remaining === 10) ? 10 : $remaining; }
    public function genererNouveauxBonus() {
        $this->bonusListe = [];
        $nbEnergie = 5; $nbPerso = 3; $nbDrones = 5;
        $casesOccupees = ["0,0", "7,7"]; 
        if ($this->joueur1) { $p=$this->joueur1->getPos(); $casesOccupees[] = "{$p['x']},{$p['y']}"; }
        if ($this->joueur2) { $p=$this->joueur2->getPos(); $casesOccupees[] = "{$p['x']},{$p['y']}"; }
        $trouverCaseLibre = function() use (&$casesOccupees) {
            do { $x = rand(0, 7); $y = rand(0, 7); $key = "$x,$y"; } while (in_array($key, $casesOccupees));
            $casesOccupees[] = $key; return ['x' => $x, 'y' => $y];
        };
            if ($this->tour % 10 === 0) { $this->genererNouveauxBonus(); $this->nouveauMessage("♻️ RÉINITIALISATION DES BONUS (Tour 10) !", 0); }
        }
        if ($this->tour > 3 && $this->phase === 1) { $this->phase = 2; $this->nouveauMessage("⚠️ DÉBUT DE LA PHASE 2 !", 0); }
        $this->getVaisseauActif()->debutDuTour();
    }
    public function verifierFinDePartie() {
        if ($this->joueur1->estDetruit()) { $this->gagnant = 2; $this->nouveauMessage("🏆 VICTOIRE J2 !", 0); }
        elseif ($this->joueur2->estDetruit()) { $this->gagnant = 1; $this->nouveauMessage("🏆 VICTOIRE J1 !", 0); }
    }
    public function sauvegarder($pdo) {
        if ($this->idBdd) {
            $data = base64_encode(serialize($this));
            $pdo->prepare("UPDATE parties SET etat_jeu = ?, joueur_tour = ? WHERE id = ?")->execute([$data, $this->joueurActif, $this->idBdd]);
        }
    }
    public static function rejoindrePartie($pdo, $code) {
        $stmt = $pdo->prepare("SELECT * FROM parties WHERE code_acces = ?");
        $stmt->execute([$code]);
        $row = $stmt->fetch();
        if (!$row) return null;
        $partie = unserialize(base64_decode($row['etat_jeu']));
        $partie->idBdd = $row['id'];
        if ($row['statut'] === 'attente') { $pdo->prepare("UPDATE parties SET statut = 'en_cours' WHERE id = ?")->execute([$row['id']]); }
        return $partie;
    }
    public static function getEtatViaId($pdo, $id) {
        $stmt = $pdo->prepare("SELECT * FROM parties WHERE id = ?");
        $stmt->execute([$id]);
        $row = $stmt->fetch();
        if ($row) { $partie = unserialize(base64_decode($row['etat_jeu'])); $partie->idBdd = $row['id']; $partie->codePartie = $row['code_acces']; return $partie; }
        return null;
    }
}