<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Règlement - Tactical Space</title>
    <style>
        /* RESET & BASE */
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body { 
            background-color: #1a1a1a; 
            color: #ecf0f1; 
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; 
            line-height: 1.6;
            display: flex;
            min-height: 100vh;
        }
        a { text-decoration: none; color: inherit; transition: 0.3s; }
        
        /* SIDEBAR (MENU) */
        .sidebar {
            width: 250px;
            background: #111;
            height: 100vh;
            position: sticky;
            top: 0;
            padding: 30px 20px;
            border-right: 1px solid #333;
            display: flex;
            flex-direction: column;
        }
        .btn-back {
            display: block;
            background: #3498db;
            color: white;
            padding: 10px;
            text-align: center;
            border-radius: 5px;
            margin-bottom: 30px;
            font-weight: bold;
        }
        .btn-back:hover { background: #2980b9; }
        
        .nav-links li { list-style: none; margin-bottom: 15px; }
        .nav-links a { 
            display: block; 
            padding: 10px; 
            border-radius: 5px; 
            color: #aaa; 
        }
        .nav-links a:hover { 
            background: #333; 
            color: #f1c40f; 
            padding-left: 15px; 
        }

        /* CONTENT */
        .content {
            flex: 1;
            padding: 40px 60px;
            max-width: 1000px;
        }
        
        h1 { font-size: 3em; margin-bottom: 20px; color: #f1c40f; text-transform: uppercase; letter-spacing: 2px; }
        h2 { font-size: 2em; margin-top: 40px; margin-bottom: 20px; color: #3498db; border-bottom: 2px solid #333; padding-bottom: 10px; }
        h3 { font-size: 1.4em; margin-bottom: 10px; color: #2ecc71; margin-top: 20px; }
        
        p { margin-bottom: 15px; color: #ccc; }

        /* CARDS SYSTEM */
        .card-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
        }
        .card {
            background: #252525;
            padding: 20px;
            border-radius: 8px;
            border-left: 4px solid #555;
            transition: transform 0.2s;
        }
        .card:hover { transform: translateY(-5px); background: #2a2a2a; }
        
        .card.atk { border-color: #e74c3c; }
        .card.def { border-color: #3498db; }
        .card.util { border-color: #f1c40f; }

        .icon { font-size: 1.5em; margin-right: 10px; vertical-align: middle; }
        .stat { font-weight: bold; color: white; background: #000; padding: 2px 6px; border-radius: 4px; font-size: 0.8em; }

        /* TABLE */
        table { width: 100%; border-collapse: collapse; margin-top: 10px; background: #252525; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #444; }
        th { background: #111; color: #f1c40f; }

        /* Highlight Text */
        .highlight { color: #f1c40f; font-weight: bold; }
    </style>
</head>
<body>

    <nav class="sidebar">
        <a href="index.php" class="btn-back">← Retour au Jeu</a>
        <ul class="nav-links">
            <li><a href="#but">1. But du Jeu</a></li>
            <li><a href="#phases">2. Les Phases</a></li>
            <li><a href="#ressources">3. Ressources</a></li>
            <li><a href="#combat">4. Combat Naval</a></li>
            <li><a href="#equipage">5. L'Équipage</a></li>
            <li><a href="#drones">6. Drones & Bonus</a></li>
        </ul>
        <div style="margin-top: auto; font-size: 0.8em; color: #555; text-align: center;">
            Tactical Space v1.1<br>MMI Project
        </div>
    </nav>

    <div class="content">
        <h1>Règlement Officiel</h1>
        <p>Bienvenue, Commandant. Voici les directives pour survivre dans le secteur Omega.</p>

        <section id="but">
            <h2>1. But du Jeu</h2>
            <p>C'est un duel tactique au tour par tour.</p>
            <div class="card util">
                <h3><span class="icon">🏆</span>Objectif Unique</h3>
                <p>Réduire les <strong>Points de Vie (PV)</strong> du vaisseau adverse à <strong>0</strong>.</p>
            </div>
        </section>

        <section id="phases">
            <h2>2. Les Phases de Jeu</h2>
            <p>La partie est divisée en deux temps distincts pour permettre la préparation stratégique.</p>
            
            <div class="card-grid">
                <div class="card def">
                    <h3>Phase 1 : Brouillard</h3>
                    <p><strong>Tours 1 à 3</strong></p>
                    <ul>
                        <li>Le terrain adverse est masqué.</li>
                        <li>Interdiction de franchir la frontière médiane.</li>
                        <li>Combat impossible.</li>
                        <li><em>Objectif : Récolter des bonus.</em></li>
                    </ul>
                </div>
                <div class="card atk">
                    <h3>Phase 2 : Combat</h3>
                    <p><strong>À partir du Tour 4</strong></p>
                    <ul>
                        <li>Le brouillard se lève.</li>
                        <li>Frontières ouvertes.</li>
                        <li>Armes et Compétences déverrouillées.</li>
                        <li><em>Objectif : Extermination.</em></li>
                    </ul>
                </div>
            </div>
        </section>

        <section id="ressources">
            <h2>3. Gestion des Ressources</h2>
            <table>
                <tr>
                    <th>Ressource</th>
                    <th>Description</th>
                    <th>Régénération</th>
                </tr>
                <tr>
                    <td><strong>PV (Structure)</strong></td>
                    <td>Votre santé. Départ à 100. Si 0 = Game Over.</td>
                    <td>Uniquement via Drone Réparation.</td>
                </tr>
                <tr>
                    <td><strong>Bouclier</strong></td>
                    <td>Absorbe les dégâts avant les PV.</td>
                    <td>Via Drone Bouclier uniquement.</td>
                </tr>
                <tr>
                    <td><strong>Énergie (⚡)</strong></td>
                    <td>Carburant pour bouger et tirer. Max 10.</td>
                    <td>+7 par tour si vous choisissez l'action "Se Reposer" (sauf si paralysé).</td>
                </tr>
            </table>
            <br>
            <p><strong>Coûts en Énergie :</strong></p>
            <ul>
                <li>Déplacement (1 case) : <span class="stat">-1 ⚡</span></li>
                <li>Tir Laser : <span class="stat">-2 ⚡</span></li>
                <li>Tir Plasma : <span class="stat">-3 ⚡</span></li>
            </ul>
        </section>

        <section id="combat">
            <h2>4. Combat Naval</h2>
            <p>Les attaques ne sont disponibles qu'en Phase 2. Vous devez gérer votre risque.</p>
            <div class="card-grid">
                <div class="card atk">
                    <h3>🔫 Canon Laser</h3>
                    <p>Coût : <strong>2 ⚡</strong></p>
                    <p>Dégâts : <strong>15</strong></p>
                    <p>Précision : <span style="color:#2ecc71">90%</span></p>
                    <small>Fiable et économique.</small>
                </div>
                <div class="card atk">
                    <h3>💣 Torpille Plasma</h3>
                    <p>Coût : <strong>3 ⚡</strong></p>
                    <p>Dégâts : <strong>35</strong></p>
                    <p>Précision : <span style="color:#e74c3c">50%</span></p>
                    <small>Dévastateur mais risqué.</small>
                </div>
            </div>
        </section>

        <section id="equipage">
            <h2>5. L'Équipage (Rôles)</h2>
            <p>Vous démarrez avec 1 membre. Vous pouvez en recruter d'autres (Max 2). Chaque rôle a une capacité unique.</p>
            
            <div class="card-grid">
                <div class="card util">
                    <h3>🔮 Mentaliste</h3>
                    <p><strong>Capacité :</strong> Entrave Psychique</p>
                    <p>Paralyse totalement l'adversaire (Mouvement + Tir) pendant <strong>1 tours</strong>.</p>
                    <p><span class="stat">Recharge : 6 tours</span></p>
                </div>
                <div class="card def">
                    <h3>📡 Opérateur</h3>
                    <p><strong>Capacité :</strong> Brouillage</p>
                    <p>Empêche l'adversaire de tirer (mais il peut bouger) pendant <strong>2 tours</strong>.</p>
                    <p><span class="stat">Recharge : 5 tours</span></p>
                </div>
                <div class="card atk">
                    <h3>🤠 Chasseur de Prime</h3>
                    <p><strong>Capacité :</strong> Assassinat</p>
                    <p>Tue instantanément un membre de l'équipage adverse.</p>
                    <p><span class="stat">Délai initial : 3 tours</span> <span class="stat">Usage Unique</span></p>
                </div>
            </div>
        </section>

        <section id="drones">
            <h2>6. Drones & Bonus</h2>
            <p>Des caisses apparaissent aléatoirement. Les drones vont dans votre <strong>Soute</strong> et doivent être déployés (coûte 1 action).</p>
            
            <table>
                <tr>
                    <th>Type</th>
                    <th>Effet</th>
                    <th>Durée</th>
                </tr>
                <tr>
                    <td>⚡ <strong>Énergie</strong></td>
                    <td>Recharge immédiate (+7).</td>
                    <td>Instantané</td>
                </tr>
                <tr>
                    <td>👤 <strong>Recrue</strong></td>
                    <td>Ajoute un membre (si place dispo).</td>
                    <td>Permanent</td>
                </tr>
                <tr>
                    <td>🛸 <strong>Drone Attaque</strong></td>
                    <td>Ajoute <strong>+15 Dégâts</strong> à vos tirs.</td>
                    <td>4 Tours</td>
                </tr>
                <tr>
                    <td>🛡️ <strong>Drone Bouclier</strong></td>
                    <td>Génère <strong>40 PV</strong> de bouclier.</td>
                    <td>3 Tours (disparaît après)</td>
                </tr>
                <tr>
                    <td>👻 <strong>Drone Esquive</strong></td>
                    <td>Réduit la précision ennemie de <strong>15%</strong>.</td>
                    <td>5 Tours</td>
                </tr>
                <tr>
                    <td>🔧 <strong>Drone Répa</strong></td>
                    <td>Soigne la coque de <strong>25 PV</strong>.</td>
                    <td>Instantané</td>
                </tr>
            </table>
            <p style="margin-top: 20px; color: #aaa; font-style: italic;">* Tous les bonus sur la carte sont réinitialisés tous les 10 tours.</p>
        </section>

    </div>
</body>
</html>