<?php
require_once __DIR__ . '/Vaisseau.php';
require_once __DIR__ . '/Bonus.php';
require_once __DIR__ . '/Drone.php';

class Partie {
    public $idBdd;
    public $joueur1;
    public $joueur2;
    public $bonusListe = [];
    public $tour;
    public $phase;
    public $joueurActif;
    public $logs = [];
    public $gagnant = null;
    public $codePartie;
    
    // NOUVEAU : Support IA
    public $modeIA = false;
    public $difficulteIA = 'moyen';
    public $joueurIA = null;

    const QUICK_MSGS = [
        'bjr' => '👋 Bonjour !', 'gg' => '🤝 Bien joué !', 'oops' => '😅 Oups...',
        'wow' => '😲 Wow !', 'chance' => '🍀 Bonne chance', 'atk' => '⚔️ À l\'attaque !',
        'non' => '⛔ Non !', 'att' => '✋ Attends...'
    ];

    public function __construct() {}

    public function nouveauMessage($texte, $auteur = 0) {
        if ($auteur === 0) $texte = $this->formaterTexteLog($texte);
        array_unshift($this->logs, ['heure' => date('H:i:s'), 'auteur' => $auteur, 'texte' => $texte]);
        if (count($this->logs) > 30) array_pop($this->logs);
    }
    private function formaterTexteLog($texte) {
        $texte = str_replace("Joueur 1", "<strong class='msg-j1'>Joueur 1</strong>", $texte);
        $texte = str_replace("Joueur 2", "<strong class='msg-j2'>Joueur 2</strong>", $texte);
        return $texte;
    }

    // --- BONUS ---
    public function verifierBonus($vaisseau) {
        $pos = $vaisseau->getPos();
        foreach ($this->bonusListe as $key => $bonus) {
            if ($bonus->x == $pos['x'] && $bonus->y == $pos['y']) {
                if ($bonus->type === 'energie') { 
                    // BONUS TERRAIN : +7
                    $vaisseau->rechargerEnergie(7); 
                    $this->nouveauMessage("⚡ Le Joueur {$vaisseau->getId()} a trouvé de l'énergie (+7).", 0); 
                }
                elseif ($bonus->type === 'personnage') { 
                    $classe = $bonus->contenu; if (class_exists($classe) && $vaisseau->ajouterMembre(new $classe())) { $this->nouveauMessage("🧑‍🚀 Recrue : $classe !", 0); } 
                }
                elseif ($bonus->type === 'drone') { 
                    $droneObj = $bonus->contenu; $vaisseau->ramasserDrone($droneObj); 
                    $this->nouveauMessage("🛸 Le Joueur {$vaisseau->getId()} a récupéré une technologie Drone.", 0); 
                }
                unset($this->bonusListe[$key]);
            }
        }
    }

    // --- LE RESTE NE CHANGE PAS ---
    public function getToursRestantsBonus() { $remaining = 10 - ($this->tour % 10); return ($remaining === 10) ? 10 : $remaining; }
    public function genererNouveauxBonus() {
        $this->bonusListe = [];
        $nbEnergie = 5; $nbPerso = 3; $nbDrones = 5;
        $casesOccupees = ["0,0", "7,7"]; 
        if ($this->joueur1) { $p=$this->joueur1->getPos(); $casesOccupees[] = "{$p['x']},{$p['y']}"; }
        if ($this->joueur2) { $p=$this->joueur2->getPos(); $casesOccupees[] = "{$p['x']},{$p['y']}"; }
        $trouverCaseLibre = function() use (&$casesOccupees) {
            do { $x = rand(0, 7); $y = rand(0, 7); $key = "$x,$y"; } while (in_array($key, $casesOccupees));
            $casesOccupees[] = $key; return ['x' => $x, 'y' => $y];
        };
        for ($i = 0; $i < $nbEnergie; $i++) { $c = $trouverCaseLibre(); $this->bonusListe[] = new Bonus('energie', 7, $c['x'], $c['y']); }
        $roles = ['Mentaliste', 'Operateur', 'Chasseur'];
        for ($i = 0; $i < $nbPerso; $i++) { $c = $trouverCaseLibre(); $this->bonusListe[] = new Bonus('personnage', $roles[array_rand($roles)], $c['x'], $c['y']); }
        $typesDrones = ['atk', 'def', 'rep', 'esq']; 
        for ($i = 0; $i < $nbDrones; $i++) { $c = $trouverCaseLibre(); $type = $typesDrones[array_rand($typesDrones)]; $this->bonusListe[] = new Bonus('drone', $type, $c['x'], $c['y']); }
    }
    
    public static function creerNouvellePartie($pdo) {
        $partie = new Partie();
        $partie->tour = 1; $partie->phase = 1; $partie->joueurActif = rand(1, 2); 
        $partie->joueur1 = new Vaisseau(1, 0, 0); $partie->joueur2 = new Vaisseau(2, 7, 7);
        $partie->genererNouveauxBonus();
        $partie->nouveauMessage("La partie commence ! Le sort a désigné le Joueur {$partie->joueurActif} pour débuter.", 0);
        $code = strtoupper(substr(md5(uniqid()), 0, 4));
        $data = base64_encode(serialize($partie));
        $pdo->prepare("INSERT INTO parties (code_acces, etat_jeu, statut, joueur_tour) VALUES (?, ?, 'attente', ?)")->execute([$code, $data, $partie->joueurActif]);
        return $code;
    }
    
    // NOUVEAU : Créer une partie Solo contre l'IA
    public static function creerPartieSolo($pdo, $difficulte = 'moyen') {
        $partie = new Partie();
        $partie->tour = 1; $partie->phase = 1;
        $partie->modeIA = true;
        $partie->difficulteIA = $difficulte;
        $partie->joueurIA = 2; // L'IA est toujours le Joueur 2
        $partie->joueurActif = rand(1, 2);
        $partie->joueur1 = new Vaisseau(1, 0, 0); 
        $partie->joueur2 = new Vaisseau(2, 7, 7);
        $partie->genererNouveauxBonus();
        
        $msgIA = "Partie Solo - Difficulté: " . ucfirst($difficulte);
        $partie->nouveauMessage($msgIA, 0);
        $partie->nouveauMessage("La partie commence ! Le sort a désigné le Joueur {$partie->joueurActif} pour débuter.", 0);
        
        $code = 'SOLO' . strtoupper(substr(md5(uniqid()), 0, 4));
        $data = base64_encode(serialize($partie));
        $pdo->prepare("INSERT INTO parties (code_acces, etat_jeu, statut, joueur_tour) VALUES (?, ?, 'en_cours', ?)")->execute([$code, $data, $partie->joueurActif]);
        $partie->idBdd = $pdo->lastInsertId();
        
        return ['code' => $code, 'id' => $partie->idBdd];
    }
    
    public function getVaisseauActif() { return ($this->joueurActif === 1) ? $this->joueur1 : $this->joueur2; }
    
    public function passerTour() {
        $this->joueurActif = ($this->joueurActif === 1) ? 2 : 1;
        if ($this->joueurActif === 1) {
            $this->tour++;
            if ($this->tour % 10 === 0) { $this->genererNouveauxBonus(); $this->nouveauMessage("♻️ RÉINITIALISATION DES BONUS (Tour 10) !", 0); }
        }
        if ($this->tour > 3 && $this->phase === 1) { $this->phase = 2; $this->nouveauMessage("⚠️ DÉBUT DE LA PHASE 2 !", 0); }
        $this->getVaisseauActif()->debutDuTour();
    }
    
    // NOUVEAU : Vérifier si c'est le tour de l'IA
    public function estTourIA() {
        return $this->modeIA && $this->joueurActif === $this->joueurIA && $this->gagnant === null;
    }
    
    // NOUVEAU : Faire jouer l'IA
    public function jouerTourIA() {
        if (!$this->estTourIA()) return false;
        
        require_once __DIR__ . '/IAJoueur.php';
        $ia = new IAJoueur($this->difficulteIA);
        $ia->jouerTour($this, $this->joueurIA);
        
        return true;
    }
    
    public function verifierFinDePartie() {
        if ($this->joueur1->estDetruit()) { $this->gagnant = 2; $this->nouveauMessage("🏆 VICTOIRE J2 !", 0); }
        elseif ($this->joueur2->estDetruit()) { $this->gagnant = 1; $this->nouveauMessage("🏆 VICTOIRE J1 !", 0); }
    }
    public function sauvegarder($pdo) {
        if ($this->idBdd) {
            $data = base64_encode(serialize($this));
            $pdo->prepare("UPDATE parties SET etat_jeu = ?, joueur_tour = ? WHERE id = ?")->execute([$data, $this->joueurActif, $this->idBdd]);
        }
    }
    public static function rejoindrePartie($pdo, $code) {
        $stmt = $pdo->prepare("SELECT * FROM parties WHERE code_acces = ?");
        $stmt->execute([$code]);
        $row = $stmt->fetch();
        if (!$row) return null;
        $partie = unserialize(base64_decode($row['etat_jeu']));
        $partie->idBdd = $row['id'];
        if ($row['statut'] === 'attente') { $pdo->prepare("UPDATE parties SET statut = 'en_cours' WHERE id = ?")->execute([$row['id']]); }
        return $partie;
    }
    public static function getEtatViaId($pdo, $id) {
        $stmt = $pdo->prepare("SELECT * FROM parties WHERE id = ?");
        $stmt->execute([$id]);
        $row = $stmt->fetch();
        if ($row) { $partie = unserialize(base64_decode($row['etat_jeu'])); $partie->idBdd = $row['id']; $partie->codePartie = $row['code_acces']; return $partie; }
        return null;
    }
}
?>