<?php
$idPartie = $_GET['id'] ?? null;
$monRole = $_GET['role'] ?? null;
// Init minimale
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/Partie.php';
require_once __DIR__ . '/Vaisseau.php'; require_once __DIR__ . '/Personne.php'; require_once __DIR__ . '/Operateur.php'; require_once __DIR__ . '/Mentaliste.php'; require_once __DIR__ . '/Chasseur.php'; require_once __DIR__ . '/Bonus.php'; require_once __DIR__ . '/Drone.php';

$partieInit = Partie::getEtatViaId($pdo, $idPartie);
$codePartie = $partieInit ? $partieInit->codePartie : '???';
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Tactical Space</title>
    <style>
        body { background-color: #222; color: white; font-family: monospace; display: flex; flex-direction: column; align-items: center; min-height: 100vh; margin: 0; padding-bottom: 50px; }
        .top-bar { background: #111; width: 100%; padding: 15px; text-align: center; border-bottom: 2px solid #444; }
        .stats-container { margin-bottom: 15px; }
        .bar-wrapper { width: 100%; background: #444; height: 10px; border-radius: 2px; margin: 4px 0; position: relative; border: 1px solid #111; }
        .bar-shield-fill { height: 100%; background: #3498db; transition: width 0.5s; }
        .bar-hp-fill { height: 100%; background: #2ecc71; transition: width 0.5s; }
        .bar-label { font-size: 11px; display: flex; justify-content: space-between; margin-top: 2px; }
        .game-area { display: flex; gap: 20px; justify-content: center; margin-top: 20px; align-items: flex-start; flex-wrap: wrap; }
        .panel { width: 260px; background: #333; padding: 15px; border-radius: 8px; border: 1px solid #444; }
        .active-panel { border: 2px solid #f1c40f; box-shadow: 0 0 15px rgba(241, 196, 15, 0.2); }
        .grid { display: grid; grid-template-columns: repeat(8, 50px); grid-gap: 3px; background: #000; border: 4px solid #555; padding: 4px; }
        .cell { width: 50px; height: 50px; background: #1a1a1a; display: flex; align-items: center; justify-content: center; font-size: 24px; position: relative; }
        .j1 { background: #3498db; border: 2px solid cyan; border-radius: 50%; width: 34px; height: 34px; }
        .j2 { background: #e74c3c; border: 2px solid orange; border-radius: 50%; width: 34px; height: 34px; }
        .bonus { font-size: 28px; }
        .valid-move { background: rgba(46, 204, 113, 0.2); border: 1px dashed #2ecc71; cursor: pointer; }
        /* NOUVEAU : Case Rouge */
        .occupied { background: rgba(231, 76, 60, 0.3); border: 1px dashed #e74c3c; cursor: not-allowed; position: relative; }
        .occupied::after { content: "❌"; position: absolute; top:0; left:0; width:100%; height:100%; display:flex; justify-content:center; align-items:center; font-size:12px; opacity:0.5; }
        
        .fog { background: repeating-linear-gradient(45deg, #050505 0, #050505 10px, #111 10px, #111 20px); }
        .action-link { display: block; width: 100%; height: 100%; position: absolute; top:0; left:0; z-index: 10; }
        .btn { display: block; width: 100%; padding: 8px; background: #555; color: white; text-decoration: none; border-radius: 4px; margin-top: 5px; text-align: center; border:none; cursor:pointer; font-family:inherit; }
        .btn:hover { background: #777; }
        .btn-atk { background: #d35400; } .btn-atk:hover { background: #e67e22; }
        .btn-spe { background: #8e44ad; } .btn-spe:hover { background: #9b59b6; }
        .btn-kill { background: #c0392b; }
        .btn-drone { background: #16a085; font-size: 0.8em; margin:0; padding:4px 8px; width:auto; display:inline-block; }
        .status-bad { color: #e74c3c; font-weight: bold; display: block; margin-bottom: 5px; animation: blink 1s infinite; border: 1px solid red; padding:4px; text-align:center; }
        .status-good { color: #2ecc71; display: block; font-size: 0.85em; border:1px solid green; padding:2px; margin-bottom:5px; text-align:center; }
        @keyframes blink { 50% { opacity: 0.5; } }
        .console-container { margin-top: 20px; width: 90%; max-width: 800px; background: #111; border: 1px solid #555; border-radius: 5px; display: flex; flex-direction: column; }
        .console-logs { height: 150px; overflow-y: auto; padding: 10px; display: flex; flex-direction: column-reverse; }
        .log-line { margin-bottom: 4px; border-bottom: 1px solid #222; padding-bottom: 2px; font-size: 0.9em; }
        .msg-sys { color: #2ecc71; } .msg-j1 { color: #3498db; } .msg-j2 { color: #e74c3c; }
        .chat-buttons { display: flex; flex-wrap: wrap; gap: 5px; padding: 10px; border-top: 1px solid #555; background: #222; }
        .btn-chat { flex: 1 0 20%; background: #444; font-size: 0.8em; padding: 8px; border:none; color:white; cursor:pointer; }
        .btn-chat:hover { background: #555; }
        .overlay { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.95); z-index: 100; display: flex; flex-direction: column; align-items: center; justify-content: center; display: none; }
    </style>
</head>
<body>
    <div id="overlay-end" class="overlay">
        <h1 style="color:gold; font-size:3em; margin-bottom:10px;">FIN DE PARTIE</h1>
        <h2 id="overlay-msg" style="color:white; margin-bottom:40px;"></h2>
        <a href="index.php" class="btn" style="width:200px; background:#3498db; padding:15px;">Retour au Menu</a>
    </div>

    <div class="top-bar">
        <span id="top-info">CHARGEMENT...</span>
        <div style="font-size:0.8em; margin-top:5px;">
            Code : 
            <span id="game-code-display" onclick="toggleBlur()" style="filter: blur(4px); cursor:pointer; margin:0 10px;">
                <?= $codePartie ?>
            </span>
            <button onclick="copyCode()" style="background:transparent; border:1px solid #555; color:white; padding: 2px 5px; font-size:0.7em; cursor:pointer;">📋 Copier</button>
            <span id="bonus-timer" style="margin-left:15px; color:#aaa;"></span>
        </div>
    </div>

    <div class="game-area">
        <div id="panel-moi" class="panel"></div>
        <div id="grid-container" class="grid"></div>
        <div id="panel-adv" class="panel"></div>
    </div>

    <div class="console-container">
        <div id="logs-container" class="console-logs"></div>
        <div class="chat-buttons">
            <?php foreach(Partie::QUICK_MSGS as $key => $txt): ?>
                <button onclick="doAction('chat', {key:'<?= $key ?>'})" class="btn-chat"><?= $txt ?></button>
            <?php endforeach; ?>
        </div>
    </div>

    <script>
        const ID_PARTIE = <?= $idPartie ?>;
        const ROLE = <?= $monRole ?>;

        function doAction(act, params = {}) {
            let formData = new FormData();
            formData.append('id', ID_PARTIE);
            formData.append('role', ROLE);
            for (const [key, value] of Object.entries(params)) {
                formData.append(key, value);
            }
            fetch(`api.php?action=${act}`, { method: 'POST', body: formData })
            .then(r => r.json()).then(data => { updateView(data); });
        }

        function refreshGame() {
            fetch(`api.php?action=get_state&id=${ID_PARTIE}&role=${ROLE}`)
            .then(r => r.json()).then(data => { updateView(data); });
        }

        function updateView(data) {
            if (!data) return;
            document.getElementById('top-info').innerHTML = data.top;
            document.getElementById('bonus-timer').innerHTML = data.bonus;
            document.getElementById('panel-moi').innerHTML = data.moi;
            document.getElementById('panel-adv').innerHTML = data.adv;
            document.getElementById('grid-container').innerHTML = data.grid;
            
            const logsDiv = document.getElementById('logs-container');
            if (logsDiv.innerHTML !== data.logs) logsDiv.innerHTML = data.logs;

            if (data.gagnant !== null) {
                document.getElementById('overlay-end').style.display = 'flex';
                const msg = (data.gagnant == ROLE) ? 
                    "<span style='color:#2ecc71'>VICTOIRE !</span>" : 
                    "<span style='color:#e74c3c'>DÉFAITE...</span>";
                document.getElementById('overlay-msg').innerHTML = msg;
            }
        }

        function toggleBlur() {
            const el = document.getElementById('game-code-display');
            el.style.filter = el.style.filter === 'blur(4px)' ? 'none' : 'blur(4px)';
        }
        function copyCode() {
            const code = document.getElementById('game-code-display').innerText.trim();
            navigator.clipboard.writeText(code);
            alert('Code copié !');
        }

        setInterval(refreshGame, 300);
        refreshGame(); 
    </script>
</body>
</html>